/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxdesktop;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxcapture.az;
import com.teamdev.jxcapture.cc;
import com.teamdev.jxcapture.fa;
import com.teamdev.jxdesktop.win32.registry.RegistryKey;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OS {
    private static final OS a;
    private Object b;
    private String c;
    private int d;
    private int e;
    private Architecture f;
    private Architecture g;

    protected OS() {
    }

    protected void init() {
        this.setName(this.detectName());
        this.setArchitecture(this.detectArchitecture());
        this.setRuntimeArchitecture(this.detectApplicationArchitecture());
        this.setMajorVersion(this.detectMajorVersion());
        this.setMinorVersion(this.detectMinorVersion());
    }

    protected int detectMinorVersion() {
        Object object = System.getProperty("os.version");
        object = new StringTokenizer((String)object, ".");
        ((StringTokenizer)object).nextToken();
        return Integer.parseInt(((StringTokenizer)object).nextToken());
    }

    protected int detectMajorVersion() {
        String string = System.getProperty("os.version");
        return Integer.parseInt(new StringTokenizer(string, ".").nextToken());
    }

    protected void setId(Object object) {
        this.b = object;
    }

    protected void setName(String string) {
        this.c = string;
    }

    protected void setMajorVersion(int n2) {
        this.d = n2;
    }

    protected void setMinorVersion(int n2) {
        this.e = n2;
    }

    protected void setArchitecture(Architecture architecture) {
        this.f = architecture;
    }

    protected void setRuntimeArchitecture(Architecture architecture) {
        this.g = architecture;
    }

    protected Architecture detectArchitecture() {
        if (PlatformContext.isX32()) {
            return Architecture.x86;
        }
        if (PlatformContext.isX64()) {
            return Architecture.amd64;
        }
        if (PlatformContext.isPPC()) {
            return Architecture.ppc;
        }
        if (PlatformContext.isPPC64()) {
            return Architecture.ppc64;
        }
        return Architecture.Unknown;
    }

    protected Architecture detectApplicationArchitecture() {
        return this.detectArchitecture();
    }

    protected final Object getId() {
        return this.b;
    }

    protected String detectName() {
        return System.getProperty("os.name");
    }

    public final String getName() {
        return this.c;
    }

    public final int getMajorVersion() {
        return this.d;
    }

    public final int getMinorVersion() {
        return this.e;
    }

    public final Architecture getArchitecture() {
        return this.f;
    }

    public final Architecture getRuntimeArchitecture() {
        return this.g;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (OS)object;
        if (this.d != ((OS)object).d) {
            return false;
        }
        if (this.e != ((OS)object).e) {
            return false;
        }
        if (this.f != ((OS)object).f) {
            return false;
        }
        if (this.b != null ? !this.b.equals(((OS)object).b) : ((OS)object).b != null) {
            return false;
        }
        if (this.c != null ? !this.c.equals(((OS)object).c) : ((OS)object).c != null) {
            return false;
        }
        return this.g == ((OS)object).g;
    }

    public int hashCode() {
        int n2 = this.b != null ? this.b.hashCode() : 0;
        n2 = n2 * 31 + (this.c != null ? this.c.hashCode() : 0);
        n2 = n2 * 31 + this.d;
        n2 = n2 * 31 + this.e;
        n2 = n2 * 31 + (this.f != null ? this.f.hashCode() : 0);
        return n2 * 31 + (this.g != null ? this.g.hashCode() : 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("OS[");
        stringBuffer.append("ID:'").append(this.getId());
        stringBuffer.append("';Name:'").append(this.getName());
        stringBuffer.append("';Version[").append(this.getMajorVersion());
        stringBuffer.append(".").append(this.getMinorVersion());
        stringBuffer.append("];Arch:").append((Object)this.getArchitecture());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static OS detect() {
        return a;
    }

    public static <E> Set<E> allVersions(Class<? extends E> clazz) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Field[] fieldArray = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(clazz)) continue;
            try {
                Object object = field.get(null);
                hashSet.add(object);
            }
            catch (Exception exception) {}
        }
        return hashSet;
    }

    public static <E extends OS> E getInstance(Class<? extends E> object, Object object2) {
        for (OS oS : OS.allVersions(object)) {
            if (!oS.getId().equals(object2)) continue;
            return (E)oS;
        }
        return null;
    }

    public static Class<? extends OS> get(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            return Class.forName(OS.class.getName() + "$" + string).asSubclass(OS.class);
        }
        catch (Exception exception) {
            return UnknownOS.class;
        }
    }

    static /* synthetic */ void a(Class clazz) {
        Field[] fieldArray = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(clazz)) continue;
            String string = field.getName();
            try {
                OS oS = (OS)field.get(null);
                oS.setId(string);
                oS.setName(string);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    static {
        Object object = System.getProperty("os.name");
        object = ((String)object).startsWith("Windows") ? Windows.a() : (((String)object).equals("Linux") ? new Linux() : (((String)object).startsWith("Mac") ? MacOSX.a() : new UnknownOS()));
        a = object;
    }

    public static final class UnknownOS
    extends OS {
        protected final int detectMinorVersion() {
            return 0;
        }

        protected final int detectMajorVersion() {
            return 0;
        }

        protected final Architecture detectArchitecture() {
            return Architecture.Unknown;
        }

        protected final String detectName() {
            return null;
        }
    }

    public static class Linux
    extends OS {
        public Linux() {
            this.init();
        }
    }

    public static class MacOSX
    extends OS {
        public static final MacOSX Tiger = new MacOSX();
        public static final MacOSX Leopard = new MacOSX();
        public static final MacOSX SnowLeopard = new MacOSX();
        public static final MacOSX Lion = new MacOSX();
        public static final MacOSX MountainLion = new MacOSX();
        public static final MacOSX Mavericks = new MacOSX();
        public static final MacOSX Yosemite = new MacOSX();

        private MacOSX() {
        }

        static MacOSX a() {
            MacOSX macOSX = new MacOSX();
            macOSX.init();
            if (macOSX.getMinorVersion() == 4) {
                Tiger.init();
                return Tiger;
            }
            if (macOSX.getMinorVersion() == 5) {
                Leopard.init();
                return Leopard;
            }
            if (macOSX.getMinorVersion() == 6) {
                SnowLeopard.init();
                return SnowLeopard;
            }
            if (macOSX.getMinorVersion() == 7) {
                Lion.init();
                return Lion;
            }
            if (macOSX.getMinorVersion() == 8) {
                MountainLion.init();
                return MountainLion;
            }
            if (macOSX.getMinorVersion() == 9) {
                Mavericks.init();
                return Mavericks;
            }
            if (macOSX.getMinorVersion() == 10) {
                Yosemite.init();
                return Yosemite;
            }
            return macOSX;
        }

        static {
            OS.a(MacOSX.class);
        }
    }

    public static class Windows
    extends OS {
        public static Windows Windows9x = new Windows();
        public static Windows Windows2000 = new Windows();
        public static Windows XP = new Windows();
        public static Windows Windows2003 = new Windows();
        public static Windows Vista = new Windows();
        public static Windows Windows2008 = new Windows();
        public static Windows Windows7 = new Windows();
        public static Windows Windows8 = new Windows();
        public static Windows Windows8_1 = new Windows();
        public static Windows Windows10 = new Windows();
        public static Windows Windows2012Server = new Windows();
        private boolean a;
        private long b;
        private String c;

        private Windows() {
        }

        private Windows a(az az2) {
            String string;
            long l2;
            boolean bl2;
            Object object = az2.h() ? "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion" : "SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
            object = RegistryKey.LOCAL_MACHINE.openSubKey((String)object, false);
            try {
                this.setName((String)((RegistryKey)((Object)object)).values().get("ProductName"));
            }
            finally {
                ((RegistryKey)((Object)object)).close();
            }
            this.setMajorVersion((int)az2.c());
            this.setMinorVersion((int)az2.d());
            Architecture architecture = super.detectArchitecture();
            this.setRuntimeArchitecture(architecture);
            if (architecture == Architecture.x86) {
                try {
                    object = new cc();
                    if (((cc)((Object)object)).b()) {
                        architecture = Architecture.amd64;
                    }
                    ((fa)((Object)object)).c();
                }
                catch (Exception exception) {
                    LoggerFactory.getLogger(OS.class).debug("Exception during detecting", (Throwable)exception);
                }
            }
            this.setArchitecture(architecture);
            this.a = bl2 = az2.h();
            this.b = l2 = az2.b();
            this.c = string = az2.g();
            return this;
        }

        public boolean isNTSystem() {
            return this.a;
        }

        public long getBuildNumber() {
            return this.b;
        }

        public String getServicePack() {
            return this.c;
        }

        static Windows a() {
            az az2;
            az az3 = az2 = new az();
            if (az2.f() == 1L) {
                return Windows9x.a(az2);
            }
            az3 = az2;
            if (az3.c() == 5L & az3.d() == 0L & az3.f() == 2L) {
                return Windows2000.a(az2);
            }
            az3 = az2;
            if (az3.c() == 5L & az3.d() == 1L & az3.f() == 2L) {
                return XP.a(az2);
            }
            az3 = az2;
            if (az3.c() == 5L & az3.d() == 2L & az3.f() == 2L) {
                return Windows2003.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & az3.d() == 0L & az3.e() == 1L) {
                return Vista.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & (az3.d() == 1L || az3.d() == 0L) & az3.e() != 1L) {
                return Windows2008.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & az3.d() == 1L & az3.e() == 1L) {
                return Windows7.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & az3.d() == 2L & az3.e() == 1L) {
                return Windows8.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & az3.d() == 3L & az3.e() == 1L) {
                return Windows8_1.a(az2);
            }
            az3 = az2;
            if (az3.c() == 10L & az3.d() == 0L & az3.e() == 1L) {
                return Windows10.a(az2);
            }
            az3 = az2;
            if (az3.c() == 6L & az3.d() == 2L & az3.e() == 3L) {
                return Windows2012Server.a(az2);
            }
            return new Windows().a(az2);
        }

        static {
            OS.a(Windows.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Architecture {
        Unknown,
        ppc,
        ppc64,
        x86,
        amd64;

    }
}

