/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win.directshow.filters;

import com.jniwrapper.Bool;
import com.teamdev.jxcapture.audio.AudioChannels;
import com.teamdev.jxcapture.audio.AudioSource;
import com.teamdev.jxcapture.video.win.directshow.filters.AVCodec;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IAMAudioInputMixerImpl;
import com.teamdev.jxdesktop.win32.com.ComException;
import com.teamdev.jxdesktop.win32.ole.b;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioSourceImpl
extends AudioSource {
    private AVCodec a;

    private AudioSourceImpl(AVCodec aVCodec) {
        if (aVCodec == null) {
            throw new NullPointerException("Null peer parameter");
        }
        if (aVCodec.getFilter().isNull()) {
            throw new IllegalArgumentException("NULL peer object");
        }
        this.a = aVCodec;
        this.setName(aVCodec.getName());
        this.checkState();
    }

    protected void checkState() {
        Logger logger = LoggerFactory.getLogger(AudioSourceImpl.class);
        try {
            IAMAudioInputMixerImpl iAMAudioInputMixerImpl = new IAMAudioInputMixerImpl(this.a.getFilter());
            try {
                Bool bool;
                try {
                    bool = new Bool();
                    iAMAudioInputMixerImpl.get_Mono(bool);
                    if (bool.getValue()) {
                        this.setChannels(AudioChannels.Mono);
                    } else {
                        this.setChannels(AudioChannels.Stereo);
                    }
                }
                catch (ComException comException) {
                    logger.debug("Cannot obtain audio channels information." + comException.getMessage());
                }
                try {
                    bool = new Bool();
                    iAMAudioInputMixerImpl.get_Enable(bool);
                    this.setEnabled(bool.getValue());
                }
                catch (ComException comException) {
                    logger.debug("Cannot get enabled state." + comException.getMessage());
                }
            }
            finally {
                iAMAudioInputMixerImpl.setAutoDelete(false);
                iAMAudioInputMixerImpl.release();
            }
        }
        catch (ComException comException) {
            logger.debug("Failed to get information from a media source: " + this.a.getName(), (Throwable)((Object)comException));
        }
    }

    public AVCodec getSource() {
        return this.a;
    }

    public static List<AudioSource> getAvailableSources() {
        LinkedList<AudioSource> linkedList = new LinkedList<AudioSource>();
        Object object = AVCodec.getAvailable(new b("{33D9A762-90C8-11d0-BD43-00A0C911CE86}"));
        object = object.iterator();
        while (object.hasNext()) {
            AVCodec aVCodec = (AVCodec)object.next();
            linkedList.add(new AudioSourceImpl(aVCodec));
        }
        return linkedList;
    }
}

