/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win.directshow;

import com.jniwrapper.UInt32;
import com.jniwrapper.WideString;
import com.teamdev.jxcapture.video.win.directshow.Bool;
import com.teamdev.jxcapture.video.win.directshow.DirectShowException;
import com.teamdev.jxcapture.video.win.directshow.FilterWrapper;
import com.teamdev.jxcapture.video.win.directshow.PinWrapper;
import com.teamdev.jxcapture.video.win.directshow.UnsupportedStreamException;
import com.teamdev.jxcapture.video.win.directshow.wrappers.IBaseFilter;
import com.teamdev.jxcapture.video.win.directshow.wrappers.IGraphBuilder;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IBaseFilterImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IEnumFiltersImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IGraphBuilderImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IMediaFilterImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IVideoWindowImpl;
import com.teamdev.jxdesktop.win32.com.ComException;
import com.teamdev.jxdesktop.win32.com.types.g;
import com.teamdev.jxdesktop.win32.ole.b;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterGraphManager {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private IGraphBuilder b;
    private Set<FilterWrapper> c = Collections.synchronizedSet(new HashSet());

    public FilterGraphManager() {
        this(GraphThreadMode.Default);
    }

    public FilterGraphManager(GraphThreadMode graphThreadMode) {
        this.b = this.createFilterGraph(graphThreadMode);
    }

    protected IGraphBuilder createFilterGraph(GraphThreadMode graphThreadMode) {
        return new IGraphBuilderImpl(new b(graphThreadMode.getClsid()), g.a);
    }

    public void clearGraph() {
        if (this.b != null && !this.b.isNull()) {
            for (FilterWrapper filterWrapper : this.c) {
                this.b.removeFilter(filterWrapper.getFilter());
                filterWrapper.release();
            }
            this.c.clear();
            this.removeAllFilters();
        }
    }

    protected List<IBaseFilter> getConnectedFilters() {
        LinkedList<IBaseFilter> linkedList = new LinkedList<IBaseFilter>();
        IEnumFiltersImpl iEnumFiltersImpl = new IEnumFiltersImpl();
        try {
            ((FilterGraphManager)object).b.enumFilters(iEnumFiltersImpl);
            Object object = new IBaseFilterImpl();
            UInt32 uInt32 = new UInt32(1L);
            while (uInt32.getValue() > 0L) {
                iEnumFiltersImpl.next(new UInt32(1L), (IBaseFilter)object, uInt32);
                if (uInt32.getValue() <= 0L) continue;
                if (!object.isNull()) {
                    linkedList.add((IBaseFilter)object);
                }
                object = new IBaseFilterImpl();
            }
        }
        finally {
            iEnumFiltersImpl.setAutoDelete(false);
            iEnumFiltersImpl.release();
        }
        return linkedList;
    }

    protected void removeAllFilters() {
        Object object = this.getConnectedFilters();
        object = object.iterator();
        while (object.hasNext()) {
            IBaseFilter iBaseFilter = (IBaseFilter)object.next();
            this.b.removeFilter(iBaseFilter);
            this.a.debug("Removed Filter: " + iBaseFilter);
            iBaseFilter.setAutoDelete(false);
            iBaseFilter.release();
        }
    }

    public void release() {
        long l2;
        this.clearGraph();
        IGraphBuilder iGraphBuilder = this.b;
        if (iGraphBuilder != null && !iGraphBuilder.isNull()) {
            iGraphBuilder.setAutoDelete(false);
            l2 = iGraphBuilder.release().getValue();
        } else {
            l2 = 0L;
        }
        long l3 = l2;
        this.a.debug("FilterGraph.release(), RefCount = " + l3);
        this.b = null;
    }

    public IGraphBuilder getFilterGraph() {
        return this.b;
    }

    public void addFilter(FilterWrapper filterWrapper) {
        if (filterWrapper == null) {
            throw new IllegalArgumentException("Invalid filter");
        }
        WideString wideString = new WideString(filterWrapper.getName());
        this.b.addFilter(filterWrapper.getFilter(), wideString);
        filterWrapper.setFilterGraph(this.b);
        this.c.add(filterWrapper);
    }

    public void removeFilter(FilterWrapper filterWrapper) {
        this.b.removeFilter(filterWrapper.getFilter());
        filterWrapper.setFilterGraph(null);
        this.c.remove(filterWrapper);
    }

    public FilterWrapper connectFilters(FilterWrapper filterWrapper, FilterWrapper filterWrapperArray, FilterWrapper[] filterWrapperArray2) {
        this.addFilter((FilterWrapper)filterWrapperArray);
        int n2 = filterWrapper.connect2((FilterWrapper)filterWrapperArray);
        if (n2 != 0) {
            return filterWrapperArray;
        }
        this.removeFilter((FilterWrapper)filterWrapperArray);
        if (filterWrapperArray2 != null) {
            filterWrapperArray = filterWrapperArray2;
            int n3 = filterWrapperArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                FilterWrapper filterWrapper2 = filterWrapperArray[n2];
                try {
                    this.addFilter(filterWrapper2);
                    if (filterWrapper.connect2(filterWrapper2)) {
                        return filterWrapper2;
                    }
                    this.removeFilter(filterWrapper2);
                    continue;
                }
                catch (ComException comException) {
                    LoggerFactory.getLogger(FilterGraphManager.class).debug("Failed to connect", (Throwable)((Object)comException));
                }
            }
        }
        return null;
    }

    public void configureVideoWindow(boolean bl2) {
        block6: {
            try {
                IVideoWindowImpl iVideoWindowImpl = new IVideoWindowImpl(((FilterGraphManager)((Object)iVideoWindowImpl)).getFilterGraph());
                if (!iVideoWindowImpl.isNull()) {
                    try {
                        iVideoWindowImpl.setAutoShow(Bool.FALSE);
                        iVideoWindowImpl.setVisible(new Bool(bl2));
                        break block6;
                    }
                    finally {
                        iVideoWindowImpl.setAutoDelete(false);
                        iVideoWindowImpl.release();
                    }
                }
                return;
            }
            catch (ComException comException) {}
        }
    }

    protected void synchronizeFilterSet() {
        Object object = this.getConnectedFilters();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (IBaseFilter)object.next();
            object2 = new FilterWrapper((IBaseFilter)object2);
            ((FilterWrapper)object2).setFilterGraph(this.b);
            this.c.add((FilterWrapper)object2);
        }
    }

    public Set<FilterWrapper> getFilters() {
        return this.c;
    }

    public FilterWrapper findAnyFilter(String ... stringArray) {
        Iterator<FilterWrapper> iterator = ((FilterGraphManager)((Object)iterator)).getFilters();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            FilterWrapper filterWrapper = iterator.next();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                if (!filterWrapper.getClsid().equalsIgnoreCase(string)) continue;
                return filterWrapper;
            }
        }
        return null;
    }

    public FilterWrapper findFilter(String string) {
        Iterator<FilterWrapper> iterator = ((FilterGraphManager)((Object)iterator)).getFilters();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            FilterWrapper filterWrapper = iterator.next();
            if (!filterWrapper.getClsid().equalsIgnoreCase(string)) continue;
            return filterWrapper;
        }
        return null;
    }

    public void connectPins(PinWrapper pinWrapper, PinWrapper pinWrapper2) {
        this.getFilterGraph().connect(pinWrapper.getPin(), pinWrapper2.getPin());
    }

    public void renderFile(File file) throws UnsupportedStreamException {
        try {
            ((FilterGraphManager)((Object)comException2)).b.renderFile(new WideString(file.getAbsolutePath()), null);
            ((FilterGraphManager)((Object)comException2)).synchronizeFilterSet();
            return;
        }
        catch (ComException comException) {
            ComException comException2 = comException;
            DirectShowException.checkResult(comException);
            return;
        }
    }

    protected void setNullSinkFilter() {
        try {
            IMediaFilterImpl iMediaFilterImpl = new IMediaFilterImpl(this.getFilterGraph());
            iMediaFilterImpl.setSyncSource(null);
            iMediaFilterImpl.setAutoDelete(false);
            iMediaFilterImpl.release();
            return;
        }
        catch (Exception exception) {
            this.a.error("Failed to set NULL sync source", (Throwable)exception);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphThreadMode {
        Default("{e436ebb3-524f-11ce-9f53-0020af0ba770}"),
        GraphPrivateThread("{a3ecbc41-581a-4476-b693-a63340462d8b}"),
        GraphNoThread("{e436ebb8-524f-11ce-9f53-0020af0ba770}");

        private String a;

        private GraphThreadMode(String string2) {
            this.a = string2;
        }

        public final String getClsid() {
            return this.a;
        }
    }
}

