/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win.directshow;

import com.teamdev.jxcapture.video.win.directshow.UnsupportedStreamException;
import com.teamdev.jxdesktop.win32.com.ComException;

public class DirectShowException {
    public static final int OUT_OF_STORAGE_ERROR = -2147024882;
    public static final int VFW_E_NO_AUDIO_HARDWARE = -2147220906;
    public static final int VFW_E_UNSUPPORTED_STREAM = -2147220891;
    public static final int VFW_E_UNSUPPORTED_AUDIO = -2147220900;
    public static final int VFW_E_CANNOT_LOAD_SOURCE_FILTER = -2147220927;
    public static final int VFW_E_INVALID_FILE_FORMAT = -2147220945;
    public static final int VFW_E_UNKNOWN_FILE_TYPE = -2147220928;
    public static final int VFW_E_CANNOT_RENDER = -2147220968;
    public static final int NS_E_UNRECOGNIZED_STREAM_TYPE = -1072889818;

    public static void checkResult(ComException comException) throws UnsupportedStreamException {
        int n2 = comException.getHResult();
        switch (n2) {
            case 0: {
                return;
            }
            case -2147024882: {
                throw new UnsupportedStreamException("Not enough storage is available.", (Throwable)((Object)comException));
            }
            case -2147220906: {
                throw new UnsupportedStreamException("Cannot play back the audio stream: no audio hardware is available, or the hardware is not responding.", (Throwable)((Object)comException));
            }
            case -2147220891: {
                throw new UnsupportedStreamException("Unsupported stream.", (Throwable)((Object)comException));
            }
            case -2147220900: {
                throw new UnsupportedStreamException("Unsupported audio.", (Throwable)((Object)comException));
            }
            case -2147220927: {
                throw new UnsupportedStreamException("Cannot load source filter.", (Throwable)((Object)comException));
            }
            case -2147220945: {
                throw new UnsupportedStreamException("Invalid file format.", (Throwable)((Object)comException));
            }
            case -2147220928: {
                throw new UnsupportedStreamException("Unknown file type.", (Throwable)((Object)comException));
            }
            case -2147221231: {
                throw new UnsupportedStreamException("Unable to find an appropriate decoder.", (Throwable)((Object)comException));
            }
            case -2147220968: {
                throw new UnsupportedStreamException("No combination of filters could be found to render the stream.", (Throwable)((Object)comException));
            }
            case -1072889818: {
                throw new UnsupportedStreamException("The specified stream type is not recognized.", (Throwable)((Object)comException));
            }
        }
        throw new UnsupportedStreamException((Throwable)((Object)comException));
    }
}

