/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win;

import com.teamdev.jxcapture.Codec;
import com.teamdev.jxcapture.EncodingParameters;
import com.teamdev.jxcapture.audio.AudioCodec;
import com.teamdev.jxcapture.audio.AudioSource;
import com.teamdev.jxcapture.audio.win.AudioCodecImpl;
import com.teamdev.jxcapture.video.VideoFormat;
import com.teamdev.jxcapture.video.win.BaseDirectShowCapture;
import com.teamdev.jxcapture.video.win.directshow.DirectShowCodec;
import com.teamdev.jxcapture.video.win.directshow.FilterGraphManager;
import com.teamdev.jxcapture.video.win.directshow.FilterWrapper;
import com.teamdev.jxcapture.video.win.directshow.encoding.wmv.AsfWriter;
import com.teamdev.jxdesktop.win32.registry.RegistryKey;
import com.teamdev.jxdesktop.win32.registry.RegistryKeyValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WMVCapture
extends BaseDirectShowCapture {
    private Logger a = LoggerFactory.getLogger(this.getClass());
    public static final DirectShowCodec MSS2 = new DirectShowCodec("{3253534D-0000-0010-8000-00AA00389B71}", "Windows Media Video 9 Screen", "MSS2");
    public static final DirectShowCodec WMV3 = new DirectShowCodec("{33564D57-0000-0010-8000-00AA00389B71}", "Windows Media Video 9", "WMV3");
    public static final DirectShowCodec WVC1 = new DirectShowCodec("{31435657-0000-0010-8000-00AA00389B71}", "Windows Media Video 9 Advanced Profile", "WVC1");
    private final AsfWriter b = new AsfWriter();

    public WMVCapture() {
        this.setResizingRequired(false);
    }

    @Override
    protected final void validate(EncodingParameters encodingParameters) {
        if (encodingParameters.getCodec() == null) {
            encodingParameters.setCodec(MSS2);
        }
        super.validate(encodingParameters);
    }

    @Override
    public final VideoFormat getVideoFormat() {
        return VideoFormat.WMV;
    }

    @Override
    public final List<Codec> getVideoCodecs() {
        ArrayList<DirectShowCodec> arrayList = new ArrayList<DirectShowCodec>(3);
        arrayList.add(WMV3);
        arrayList.add(MSS2);
        RegistryKey registryKey = null;
        try {
            registryKey = RegistryKey.CLASSES_ROOT.openSubKey("MediaFoundation\\Transforms\\Preferred");
            RegistryKeyValues registryKeyValues = registryKey.values();
            if (registryKeyValues.containsKey(WVC1.getId().toString())) {
                arrayList.add(WVC1);
            } else {
                this.a.debug("WVC1 is not available in the system - excluding it from the list of codecs");
            }
        }
        catch (Exception exception) {
            this.a.debug("Failed to get information about WVC1 codec from Windows registry", (Throwable)exception);
        }
        finally {
            if (registryKey != null) {
                registryKey.close();
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public final List<AudioCodec> getAudioCodecs() {
        ArrayList<AudioCodecImpl> arrayList = new ArrayList<AudioCodecImpl>(3);
        arrayList.add(AudioCodecImpl.WMSP1);
        arrayList.add(AudioCodecImpl.WMAudioV8);
        arrayList.add(AudioCodecImpl.WMAudio_Lossless);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    protected final void configure(FilterGraphManager filterGraphManager, FilterWrapper filterWrapper, FilterWrapper filterWrapper2) {
        AudioSource audioSource;
        FilterWrapper filterWrapper3 = this.b.getPeer();
        filterGraphManager.addFilter(filterWrapper3);
        EncodingParameters encodingParameters = this.getEncodingParameters();
        if (encodingParameters.getSize() == null) {
            encodingParameters.setSize(this.getCaptureArea().getSize());
        }
        if ((audioSource = this.getAudioSource()) == null) {
            encodingParameters.setAudioEncoding(null);
        }
        this.b.configure(encodingParameters);
        if (!filterWrapper.connect2(filterWrapper3)) {
            throw new RuntimeException("Failed to connect videoSource to ASF Writer");
        }
        if (filterWrapper2 != null) {
            filterGraphManager.addFilter(filterWrapper2);
            filterWrapper2.connectFilterByPin("Capture", filterWrapper3, "Audio Input 01");
        }
    }

    @Override
    protected final void release() {
        FilterWrapper filterWrapper = this.b.getPeer();
        this.getFilterGraphManager().removeFilter(filterWrapper);
        filterWrapper.release();
        super.release();
    }
}

