/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.ULongInt;
import com.teamdev.jxcapture.Configurable;
import com.teamdev.jxcapture.image.ImageSource;
import com.teamdev.jxcapture.image.win.BitmapType;
import com.teamdev.jxcapture.image.win.ImmutableBitmap;
import com.teamdev.jxcapture.video.VideoSource;
import com.teamdev.jxcapture.video.win.directshow.Bool;
import com.teamdev.jxcapture.video.win.directshow.FilterGraphManager;
import com.teamdev.jxcapture.video.win.directshow.FilterWrapper;
import com.teamdev.jxcapture.video.win.directshow.PinWrapper;
import com.teamdev.jxcapture.video.win.directshow.filters.AVCodec;
import com.teamdev.jxcapture.video.win.directshow.filters.ColorSpaceConverter;
import com.teamdev.jxcapture.video.win.directshow.filters.SampleGrabber;
import com.teamdev.jxcapture.video.win.directshow.filters.SmartTee;
import com.teamdev.jxcapture.video.win.directshow.filters.VideoRenderer;
import com.teamdev.jxcapture.video.win.directshow.wrappers.CAUUID;
import com.teamdev.jxcapture.video.win.directshow.wrappers.IMediaControl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.MediaType;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IMediaControlImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.ISpecifyPropertyPagesImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IVideoWindowImpl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.server.SampleGrabberCallback;
import com.teamdev.jxcapture.y;
import com.teamdev.jxdesktop.win32.HResult;
import com.teamdev.jxdesktop.win32.com.ComException;
import com.teamdev.jxdesktop.win32.com.ComFunctions;
import com.teamdev.jxdesktop.win32.com.c;
import com.teamdev.jxdesktop.win32.com.impl.IUnknownImpl;
import com.teamdev.jxdesktop.win32.ole.GUID;
import com.teamdev.jxdesktop.win32.ole.b;
import com.teamdev.jxdesktop.win32.ui.Wnd;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoCaptureImpl
extends VideoSource
implements Configurable {
    private static final Logger a = LoggerFactory.getLogger(VideoCaptureImpl.class);
    private static final GUID b = GUID.string2GUID("{73646976-0000-0010-8000-00AA00389B71}");
    private final BitmapType c = BitmapType.RGB32;
    private FilterWrapper d;
    private FilterGraphManager e;
    private IMediaControl f;
    private SampleGrabber g;
    private SampleGrabberCallback h;
    private MediaType i = new MediaType();
    private FilterWrapper j;
    private SmartTee k;
    private FilterWrapper l;
    private boolean m = false;
    private boolean n = false;

    private VideoCaptureImpl(FilterWrapper object) {
        if (object == null) {
            throw new NullPointerException("Null peer parameter");
        }
        if (((FilterWrapper)object).getFilter().isNull()) {
            throw new IllegalArgumentException("NULL peer object");
        }
        this.d = object;
        this.setName(((FilterWrapper)object).getName());
        this.e = new FilterGraphManager();
        this.k = new SmartTee();
        this.j = new VideoRenderer();
        this.g = new SampleGrabber(new MediaType(b, this.c.getMediaSubtype()));
        this.l = new ColorSpaceConverter();
        this.h = SampleGrabberCallback.create();
        this.g.setCallback(this.h.getCallback());
        this.e.addFilter(this.d);
        this.e.addFilter(this.k);
        this.e.addFilter(this.l);
        this.e.addFilter(this.g);
        this.e.addFilter(this.j);
        if (!this.d.connect2(this.k)) {
            throw new RuntimeException("Failed to connect video source to SmartTee");
        }
        object = this.k.getOutputPin("Preview");
        if (object == null) {
            throw new IllegalStateException("Could not get SmartTee's 'Preview' pin");
        }
        PinWrapper pinWrapper = this.l.getInputPin("Input");
        if (pinWrapper == null) {
            throw new IllegalStateException("Could not get ColorSpaceConverter's 'Input' pin");
        }
        try {
            this.e.getFilterGraph().connect(((PinWrapper)object).getPin(), pinWrapper.getPin());
        }
        catch (ComException comException) {
            throw new IllegalStateException("Failed to connect SmartTee's 'Preview' pin and ColorSpaceConverter's 'Input' pin", (Throwable)((Object)comException));
        }
        finally {
            ((PinWrapper)object).release();
            pinWrapper.release();
        }
        if (!this.l.connect2(this.g)) {
            throw new IllegalStateException("Cannot connect 'colorSpaceConverter' to 'grabber'.");
        }
        if (!this.g.connect2(this.j)) {
            throw new IllegalStateException("Cannot connect 'grabber' to 'renderer'.");
        }
        try {
            object = this.j;
            object = new IVideoWindowImpl(((FilterWrapper)object).getFilter());
            ((IVideoWindowImpl)object).setAutoShow(Bool.FALSE);
            ((IVideoWindowImpl)object).setVisible(Bool.FALSE);
            ((IUnknownImpl)object).setAutoDelete(false);
            ((IUnknownImpl)object).release();
        }
        catch (ComException comException) {
            a.debug("Failed to configure 'renderer'", (Throwable)((Object)comException));
        }
        this.i = this.g.getMediaType();
        Structure structure = this.i.getSubtype();
        if (!structure.equals((Object)this.c.getMediaSubtype())) {
            throw new IllegalStateException("Actual media type: " + structure + " does not correspond to the required one: " + (Object)((Object)this.c));
        }
        structure = this.i.getVideoInfoHeader();
        object = structure.getBmiHeader();
        this.setSize(new Dimension((int)((y)((Object)object)).b(), (int)((y)((Object)object)).c()));
        this.f = new IMediaControlImpl(this.e.getFilterGraph());
    }

    @Override
    public void activate() {
        this.a().run();
    }

    @Override
    public void deactivate() {
        if (this.m) {
            this.n = true;
            return;
        }
        this.stop();
    }

    @Override
    public Object getData() {
        this.m = true;
        Object object = this;
        object = ((VideoCaptureImpl)object).a();
        Int32 int32 = new Int32();
        int n2 = 0;
        while (true) {
            try {
                object.getState(new Int32(0), int32);
            }
            catch (ComException comException) {
                a.debug("Failed to get a graph state", (Throwable)((Object)comException));
                throw new IllegalStateException("Failed to get a graph state", (Throwable)((Object)comException));
            }
            if (++n2 == 20) {
                throw new IllegalStateException("Device was not responding for 2000 milliseconds");
            }
            if (int32.getValue() == (long)com.teamdev.jxcapture.video.win.VideoCaptureImpl$a.a.ordinal()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                a.debug("Got InterruptedException while waiting for the running state", (Throwable)interruptedException);
            }
        }
        object = this.takeScreenshot();
        this.m = false;
        if (this.n) {
            this.stop();
            this.n = false;
        }
        return object;
    }

    public ImmutableBitmap takeScreenshot() {
        byte[] byArray;
        try {
            byArray = ((VideoCaptureImpl)((Object)dimension)).h.grab();
        }
        catch (Exception exception) {
            a.error("Failed to get image", (Throwable)exception);
            return null;
        }
        Object object = ((VideoCaptureImpl)((Object)dimension)).i.getSubtype();
        Dimension dimension = ((ImageSource)((Object)dimension)).getSize();
        try {
            object = BitmapType.fromGUID(object);
            return new ImmutableBitmap(byArray, true, dimension.width, dimension.height, (BitmapType)((Object)object));
        }
        catch (Exception exception) {
            a.error("Failed to get image", (Throwable)exception);
            return null;
        }
    }

    public SmartTee getVideoSourceFilter() {
        return this.k;
    }

    public FilterGraphManager getFilterGraphManager() {
        return this.e;
    }

    private IMediaControl a() {
        if (this.f == null || this.f.isNull()) {
            throw new IllegalStateException("MediaControl is already disposed");
        }
        return this.f;
    }

    public void run() {
        this.a().run();
    }

    public void stop() {
        this.a().stop();
    }

    @Override
    public void release() {
        if (this.f != null && !this.f.isNull()) {
            this.f.stop();
            this.f.release();
            this.f = null;
        }
        this.h.release();
        if (this.e != null) {
            this.e.release();
            this.e = null;
        }
    }

    public static List<VideoSource> getVideoCaptureSources() {
        Object object = AVCodec.getAvailable(new b("{860BB310-5D01-11d0-BD3B-00A0C911CE86}"));
        LinkedList<VideoSource> linkedList = new LinkedList<VideoSource>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (AVCodec)object.next();
            try {
                object2 = new VideoCaptureImpl((FilterWrapper)object2);
                linkedList.add((VideoSource)object2);
            }
            catch (Exception exception) {
                a.debug("Failed to get video source", (Throwable)exception);
            }
        }
        return linkedList;
    }

    @Override
    public boolean configure() {
        ISpecifyPropertyPagesImpl iSpecifyPropertyPagesImpl = new ISpecifyPropertyPagesImpl(videoCaptureImpl.d.getFilter());
        CAUUID cAUUID = iSpecifyPropertyPagesImpl.getPages();
        Function function = ComFunctions.getInstance().getFunction("OleCreatePropertyFrame");
        HResult hResult = new HResult();
        function.invoke((Parameter)hResult, new Parameter[]{new Wnd(), new UInt(0L), new UInt(0L), new com.teamdev.jxdesktop.win32.ole.a(videoCaptureImpl.getName()), new ULongInt(1L), new Pointer((Parameter)videoCaptureImpl.d.getFilter()), new ULongInt(cAUUID.getElementsCount()), cAUUID.getElementsPointer(), new Int(0L), new UInt32(0L), new Pointer.Void()});
        iSpecifyPropertyPagesImpl.setAutoDelete(false);
        iSpecifyPropertyPagesImpl.release();
        VideoCaptureImpl videoCaptureImpl = com.teamdev.jxdesktop.win32.com.c.a().getFunction("CoTaskMemFree");
        videoCaptureImpl.invoke(null, (Parameter)cAUUID.getElementsPointer());
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    extends Enum<a> {
        private static /* enum */ a b = new a();
        private static /* enum */ a c = new a();
        public static final /* enum */ a a = new a();

        static {
            a[] aArray = new a[]{b, c, a};
        }
    }
}

