/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win;

import com.teamdev.jxcapture.VideoCapture;
import com.teamdev.jxcapture.video.Desktop;
import com.teamdev.jxcapture.video.FullScreen;
import com.teamdev.jxcapture.video.VideoSource;
import com.teamdev.jxcapture.video.WindowSource;
import com.teamdev.jxcapture.video.win.VideoCaptureImpl;
import com.teamdev.jxcapture.video.win.a;
import com.teamdev.jxcapture.video.win.b;
import com.teamdev.jxcapture.video.win.c;
import com.teamdev.jxcapture.video.win.d;
import com.teamdev.jxcapture.video.win.directshow.FilterGraphManager;
import com.teamdev.jxcapture.video.win.directshow.FilterWrapper;
import com.teamdev.jxcapture.video.win.directshow.PinWrapper;
import com.teamdev.jxcapture.video.win.directshow.filters.AVCodec;
import com.teamdev.jxcapture.video.win.directshow.filters.AudioSourceImpl;
import com.teamdev.jxcapture.video.win.directshow.filters.ColorSpaceConverter;
import com.teamdev.jxcapture.video.win.directshow.filters.ScreenCaptureFilter;
import com.teamdev.jxcapture.video.win.directshow.filters.SmartTee;
import com.teamdev.jxcapture.video.win.directshow.wrappers.IMediaControl;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IMediaControlImpl;
import com.teamdev.jxcapture.video.win.e;
import com.teamdev.jxdesktop.OS;
import com.teamdev.jxdesktop.win32.WindowsUIElement;
import com.teamdev.jxdesktop.win32.com.ComException;
import com.teamdev.jxdesktop.win32.com.OleMessageLoop;
import com.teamdev.jxdesktop.win32.l;
import java.awt.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDirectShowCapture
extends VideoCapture {
    private Logger a = LoggerFactory.getLogger(this.getClass());
    private OleMessageLoop b;
    private FilterGraphManager c;
    private boolean d;
    private IMediaControl e;
    private boolean f = true;
    private boolean g = false;
    private ScreenCaptureFilter h;
    private ColorSpaceConverter i;
    private FilterWrapper j;
    private SmartTee k;
    private FrameRateMode l = FrameRateMode.TickCountBased;

    protected BaseDirectShowCapture(VideoSource object) {
        super((VideoSource)object);
        this.setFramerate(15);
        object = OS.detect();
        if (!(object instanceof OS.Windows)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " cannot be used on this platform");
        }
    }

    protected BaseDirectShowCapture() {
        this(new Desktop());
    }

    protected void doStart() {
        this.a.debug(this + ".doStart");
        this.b = new OleMessageLoop("Encoding message loop." + this.getClass().getSimpleName());
        this.b.doStart();
        try {
            this.b.doInvokeAndWait(new e(this));
        }
        catch (Exception exception) {
            this.a.error("Could not configure filter graph manager", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        if (!this.g) {
            BaseDirectShowCapture baseDirectShowCapture = this;
            VideoSource videoSource = baseDirectShowCapture.getVideoSource();
            if (videoSource instanceof Desktop || videoSource instanceof FullScreen || videoSource instanceof WindowSource) {
                baseDirectShowCapture.a(videoSource);
            } else if (videoSource instanceof VideoCaptureImpl) {
                baseDirectShowCapture.a((VideoCaptureImpl)videoSource);
            } else {
                throw new IllegalStateException("Unsupported video source: " + videoSource);
            }
            baseDirectShowCapture.e = new IMediaControlImpl(baseDirectShowCapture.c.getFilterGraph());
            this.g = true;
        }
        try {
            this.b.doInvokeAndWait(new c(this));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void a(VideoCaptureImpl object) {
        if (this.c != null) {
            this.c.release();
        }
        ((VideoCaptureImpl)object).stop();
        this.c = ((VideoCaptureImpl)object).getFilterGraphManager();
        this.d = true;
        this.k = ((VideoCaptureImpl)object).getVideoSourceFilter();
        this.i = new ColorSpaceConverter();
        this.c.addFilter(this.i);
        object = this.k.getOutputPin("Capture");
        if (object == null) {
            throw new IllegalStateException("Could not get SmartTee's 'Preview' pin");
        }
        PinWrapper pinWrapper = this.i.getInputPin("Input");
        if (pinWrapper == null) {
            throw new IllegalStateException("Could not get ColorSpaceConverter's 'Input' pin");
        }
        try {
            this.c.getFilterGraph().connect(((PinWrapper)object).getPin(), pinWrapper.getPin());
        }
        catch (ComException comException) {
            throw new IllegalStateException("Failed to connect SmartTee's 'Capture' pin and ColorSpaceConverter 'Input' pin", (Throwable)((Object)comException));
        }
        finally {
            ((PinWrapper)object).release();
            pinWrapper.release();
        }
        this.j = this.getAudioSourceFilter();
        if (this.j != null) {
            if (this.getEncodingParameters().getAudioEncoding() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Audio encoding parameters are not configured");
            }
            this.c.addFilter(this.j);
            this.setFrameRateMode(FrameRateMode.Actual);
        }
        this.configure(this.c, this.i, this.j);
    }

    private void a(VideoSource object) {
        Object object2;
        this.h = new ScreenCaptureFilter();
        if (object instanceof Desktop || object instanceof FullScreen) {
            this.h.setMode(ScreenCaptureFilter.CaptureMode.Rectangle);
        } else if (object instanceof WindowSource) {
            this.h.setMode(ScreenCaptureFilter.CaptureMode.WindowRectangle);
            object = (WindowSource)object;
            object2 = (l)((WindowSource)object).getWindow();
            this.h.setWindow(((WindowsUIElement)object2).getWindow());
        }
        this.addPropertyChangeListener("CaptureBase.CaptureArea", new d(this));
        this.c.addFilter(this.h);
        object = this.getAudioSourceFilter();
        if (object != null) {
            if (this.getEncodingParameters().getAudioEncoding() == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Audio encoding parameters are not configured");
            }
            this.c.addFilter((FilterWrapper)object);
            this.setFrameRateMode(FrameRateMode.Actual);
        }
        this.h.setFrameRate(this.getFramerate().getValue());
        this.h.setFrameRateMode(this.getFrameRateMode());
        this.h.setIncludeCursor(this.isIncludeCursor());
        this.h.setCaptureTransparentWindows(this.isCaptureTransparentWindows());
        this.h.setRectangle(new com.teamdev.jxdesktop.win32.a(this.getCaptureArea()));
        this.h.setInterpolationMode(this.getEncodingParameters().getInterpolationMode());
        try {
            if (this.isResizingRequired()) {
                object2 = this.getCaptureArea().getSize();
                Dimension dimension = this.getEncodingParameters().getSize();
                if (dimension != null && !((Dimension)object2).equals(dimension)) {
                    this.h.setOutputDimentions(dimension);
                }
            }
            this.h.configure();
            this.configure(this.c, this.h, (FilterWrapper)object);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to configure the screen capture to encode video in a specified format.", exception);
        }
    }

    protected FilterWrapper getAudioSourceFilter() {
        AVCodec aVCodec = null;
        if ((object = ((VideoCapture)object).getAudioSource()) != null && object instanceof AudioSourceImpl) {
            Object object = (AudioSourceImpl)object;
            aVCodec = ((AudioSourceImpl)object).getSource();
        }
        return aVCodec;
    }

    protected abstract void configure(FilterGraphManager var1, FilterWrapper var2, FilterWrapper var3);

    protected void doStop() {
        this.a.debug(this + ".doStop()");
        try {
            this.b.doInvokeAndWait(new a(this));
        }
        catch (InterruptedException interruptedException) {
            this.a.debug("Got interrupted exception");
        }
        catch (Exception exception) {
            this.a.error("Got exception", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        this.b.doStop();
    }

    protected void release() {
        if (this.i != null) {
            this.c.removeFilter(this.i);
            this.i.release();
        }
        if (this.j != null) {
            this.c.removeFilter(this.j);
            this.j.release();
        }
    }

    protected void doPause() {
        this.a.debug(this + ".doPause");
        try {
            this.b.doInvokeAndWait(new b(this));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected boolean isResizingRequired() {
        return this.f;
    }

    protected void setResizingRequired(boolean bl2) {
        this.f = bl2;
    }

    protected FrameRateMode getFrameRateMode() {
        return this.l;
    }

    protected void setFrameRateMode(FrameRateMode frameRateMode) {
        this.l = frameRateMode;
    }

    protected FilterGraphManager getFilterGraphManager() {
        return this.c;
    }

    public OleMessageLoop getMessageLoop() {
        return this.b;
    }

    static /* synthetic */ FilterGraphManager a(BaseDirectShowCapture baseDirectShowCapture, FilterGraphManager filterGraphManager) {
        baseDirectShowCapture.c = filterGraphManager;
        return baseDirectShowCapture.c;
    }

    static /* synthetic */ boolean a(BaseDirectShowCapture baseDirectShowCapture, boolean bl2) {
        baseDirectShowCapture.d = false;
        return false;
    }

    static /* synthetic */ IMediaControl a(BaseDirectShowCapture baseDirectShowCapture) {
        return baseDirectShowCapture.e;
    }

    static /* synthetic */ ScreenCaptureFilter b(BaseDirectShowCapture baseDirectShowCapture) {
        return baseDirectShowCapture.h;
    }

    static /* synthetic */ SmartTee c(BaseDirectShowCapture baseDirectShowCapture) {
        return baseDirectShowCapture.k;
    }

    static /* synthetic */ boolean d(BaseDirectShowCapture baseDirectShowCapture) {
        return baseDirectShowCapture.d;
    }

    static /* synthetic */ FilterGraphManager e(BaseDirectShowCapture baseDirectShowCapture) {
        return baseDirectShowCapture.c;
    }

    static /* synthetic */ IMediaControl a(BaseDirectShowCapture baseDirectShowCapture, IMediaControl iMediaControl) {
        baseDirectShowCapture.e = null;
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameRateMode {
        Defined,
        Actual,
        TickCountBased;

    }
}

