/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.win;

import com.teamdev.jxcapture.BaseEncodingParameters;
import com.teamdev.jxcapture.Codec;
import com.teamdev.jxcapture.EncodingParameters;
import com.teamdev.jxcapture.Format;
import com.teamdev.jxcapture.audio.AudioCodec;
import com.teamdev.jxcapture.audio.AudioEncodingParameters;
import com.teamdev.jxcapture.audio.win.AudioCodecImpl;
import com.teamdev.jxcapture.video.VideoFormat;
import com.teamdev.jxcapture.video.win.BaseDirectShowCapture;
import com.teamdev.jxcapture.video.win.directshow.DirectShowCodec;
import com.teamdev.jxcapture.video.win.directshow.DirectShowVideoEncoder;
import com.teamdev.jxcapture.video.win.directshow.FilterGraphManager;
import com.teamdev.jxcapture.video.win.directshow.FilterWrapper;
import com.teamdev.jxcapture.video.win.directshow.filters.AviMux;
import com.teamdev.jxcapture.video.win.directshow.filters.FileWriter;
import com.teamdev.jxcapture.video.win.directshow.wrappers.impl.IConfigInterleavingImpl;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AVICapture
extends BaseDirectShowCapture {
    private static List<Codec> a = new LinkedList<Codec>();
    private FilterWrapper b;
    private FilterWrapper c;
    private FilterWrapper d;

    @Override
    public final VideoFormat getVideoFormat() {
        return VideoFormat.AVI;
    }

    @Override
    public final List<Codec> getVideoCodecs() {
        LinkedList linkedList = DirectShowVideoEncoder.getAvailableEncoders();
        linkedList = new LinkedList(linkedList);
        linkedList.removeAll(a);
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    protected final void validate(EncodingParameters encodingParameters) {
        super.validate(encodingParameters);
        if (encodingParameters.getCodec() == null) {
            throw new IllegalArgumentException("Video codec is not specified");
        }
    }

    @Override
    public final List<AudioCodec> getAudioCodecs() {
        ArrayList<AudioCodecImpl> arrayList = new ArrayList<AudioCodecImpl>(1);
        arrayList.add(AudioCodecImpl.PCM);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    protected final void configure(FilterGraphManager filterGraphManager, FilterWrapper filterWrapper, FilterWrapper filterWrapper2) {
        Object object = this.getEncodingParameters();
        Object object2 = ((BaseEncodingParameters)object).getCodec();
        this.b = object2 instanceof DirectShowCodec ? ((DirectShowCodec)object2).getPeer() : new FilterWrapper(((Format)object2).getId().toString(), ((Format)object2).getName());
        filterGraphManager.addFilter(this.b);
        if (((EncodingParameters)object).getSize() == null) {
            ((EncodingParameters)object).setSize(this.getCaptureArea().getSize());
        }
        ((Codec)object2).configure((EncodingParameters)object);
        boolean bl2 = filterWrapper.connect2(this.b);
        if (!bl2) {
            throw new RuntimeException("Failed to connect a videoSource filter to video encoder: " + object2);
        }
        this.c = new AviMux();
        filterGraphManager.addFilter(this.c);
        IConfigInterleavingImpl iConfigInterleavingImpl = new IConfigInterleavingImpl(this.c.getFilter());
        iConfigInterleavingImpl.setMode(IConfigInterleavingImpl.InterleavingMode.Capture);
        iConfigInterleavingImpl.setInterleaving(40L, 0L);
        iConfigInterleavingImpl.setAutoDelete(false);
        iConfigInterleavingImpl.release();
        boolean bl3 = this.b.connect2(this.c);
        if (!bl3) {
            throw new RuntimeException("Failed to connect a video codec to AVI Mux");
        }
        this.d = new FileWriter(((EncodingParameters)object).getOutputFile().getAbsolutePath());
        filterGraphManager.addFilter(this.d);
        bl3 = this.c.connect2(this.d);
        if (!bl3) {
            throw new RuntimeException("Failed to connect AVI Mux to File Writer");
        }
        AudioEncodingParameters audioEncodingParameters = ((EncodingParameters)object).getAudioEncoding();
        if (audioEncodingParameters != null) {
            object = audioEncodingParameters.getCodec();
            if (filterWrapper2 != null && object != null) {
                object2 = ((AudioCodecImpl)object).getPeer();
                filterGraphManager.addFilter((FilterWrapper)object2);
                boolean bl4 = filterWrapper2.connect2((FilterWrapper)object2);
                if (!bl4) {
                    throw new RuntimeException("Failed to connect audio source to audio codec: " + object);
                }
                bl4 = ((FilterWrapper)object2).connect2(this.c);
                if (!bl4) {
                    throw new RuntimeException("Failed to connect audio codec to AVI Muxer");
                }
            }
        }
    }

    @Override
    protected final void release() {
        FilterGraphManager filterGraphManager = this.getFilterGraphManager();
        if (filterGraphManager != null) {
            if (this.b != null) {
                filterGraphManager.removeFilter(this.b);
                this.b.release();
                this.b = null;
            }
            if (this.c != null) {
                filterGraphManager.removeFilter(this.c);
                this.c.release();
                this.c = null;
            }
            if (this.d != null) {
                filterGraphManager.removeFilter(this.d);
                this.d.release();
                this.d = null;
            }
        }
        super.release();
    }

    static {
        Closeable closeable = AVICapture.class.getResourceAsStream("UnusedCodecs.properties");
        try {
            String string;
            closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
            while ((string = ((BufferedReader)closeable).readLine()) != null) {
                a.add(new Codec(string));
            }
        }
        catch (IOException iOException) {
            Logger logger = LoggerFactory.getLogger(AVICapture.class);
            logger.error("Could not read the list of unused codecs", (Throwable)iOException);
        }
    }
}

