/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.player;

import com.teamdev.jxcapture.video.player.MediaInfo;
import com.teamdev.jxcapture.video.player.win.DirectShowVideoPlayer;
import com.teamdev.jxdesktop.OS;
import java.awt.BorderLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VideoPlayerComponent
extends JComponent {
    public static final String PROPERTY_STATE = "PlayerState";
    protected final PlayerState[] playerState = new PlayerState[]{PlayerState.Uninitialized};

    public PlayerState getPlayerState() {
        return this.playerState[0];
    }

    protected void setPlayerState(PlayerState playerState) {
        if (this.playerState[0] != playerState) {
            PlayerState playerState2 = this.playerState[0];
            this.playerState[0] = playerState;
            this.firePropertyChange(PROPERTY_STATE, (Object)playerState2, (Object)playerState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MediaInfo open(File object) throws IOException {
        if (object == null) {
            throw new NullPointerException("File is null");
        }
        if (!((File)object).exists()) {
            throw new IOException("Specified file does does not exist");
        }
        PlayerState[] playerStateArray = this.playerState;
        synchronized (this.playerState) {
            this.setPlayerState(PlayerState.Uninitialized);
            object = this.doOpen((File)object);
            this.setPlayerState(PlayerState.Initialized);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return object;
        }
    }

    public abstract MediaInfo doOpen(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        PlayerState[] playerStateArray = this.playerState;
        synchronized (this.playerState) {
            this.a();
            this.doStart();
            this.setPlayerState(PlayerState.Playing);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    private void a() {
        if (this.getPlayerState() == PlayerState.Uninitialized) {
            throw new IllegalStateException("Player is not initialized");
        }
    }

    protected abstract void doStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        PlayerState[] playerStateArray = this.playerState;
        synchronized (this.playerState) {
            this.a();
            this.doPause();
            this.setPlayerState(PlayerState.Paused);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void doPause();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        PlayerState[] playerStateArray = this.playerState;
        synchronized (this.playerState) {
            this.a();
            this.doStop();
            this.setPlayerState(PlayerState.Stopped);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        PlayerState[] playerStateArray = this.playerState;
        synchronized (this.playerState) {
            this.doRelease();
            this.setPlayerState(PlayerState.Uninitialized);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void doRelease();

    public abstract double getPosition();

    public abstract void setPosition(double var1);

    public abstract void setVolume(int var1);

    public abstract int getVolume();

    public static VideoPlayerComponent create() {
        OS oS = OS.detect();
        if (oS instanceof OS.Windows) {
            return new DirectShowVideoPlayer();
        }
        if (oS instanceof OS.MacOSX) {
            throw new UnsupportedOperationException("Video player component is not implemented for " + oS + " platform yet");
        }
        throw new UnsupportedOperationException("Video player component cannot be created for this platform: " + oS);
    }

    public static class NulPlayer
    extends VideoPlayerComponent {
        private Logger a = LoggerFactory.getLogger(NulPlayer.class);

        public NulPlayer() {
            this.setLayout(new BorderLayout());
            this.add(new JLabel("This player cannot render video"));
        }

        public MediaInfo doOpen(File file) throws IOException {
            this.a.error("Trying to open a file in component");
            return null;
        }

        protected void doStart() {
            this.a.error("Trying to start component");
        }

        public void doPause() {
            this.a.error("Trying to pause component");
        }

        public void doStop() {
            this.a.error("Trying to stop component");
        }

        public void doRelease() {
            this.a.error("Trying to release component");
        }

        public double getPosition() {
            this.a.error("Trying to get position");
            return 0.0;
        }

        public void setPosition(double d2) {
            this.a.error("Trying to set position");
        }

        public void setVolume(int n2) {
            this.a.error("Trying to set volume");
        }

        public int getVolume() {
            this.a.error("Trying to get volume");
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlayerState {
        Uninitialized,
        Initialized,
        Playing,
        Paused,
        Stopped;

    }
}

