/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.video.mac;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Bool;
import com.jniwrapper.DoubleFloat;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.SingleFloat;
import com.teamdev.jxcapture.Codec;
import com.teamdev.jxcapture.Format;
import com.teamdev.jxcapture.audio.AudioSource;
import com.teamdev.jxcapture.audio.mac.AudioCodecImpl;
import com.teamdev.jxcapture.audio.mac.AudioSourceImpl;
import com.teamdev.jxcapture.cf;
import com.teamdev.jxcapture.dn;
import com.teamdev.jxcapture.video.Desktop;
import com.teamdev.jxcapture.video.FullScreen;
import com.teamdev.jxcapture.video.VideoSource;
import com.teamdev.jxcapture.video.WindowSource;
import com.teamdev.jxcapture.video.mac.LionVideoDevice;
import com.teamdev.jxcapture.video.mac.a;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;

public class LionVideoCapture
extends a {
    private String a;

    public LionVideoCapture() {
        this(new Desktop());
    }

    public LionVideoCapture(VideoSource videoSource) {
        super(videoSource);
        this.codecs = new ArrayList(2);
        this.codecs.add(new Codec(1635148593, "H.264"));
        this.codecs.add(new Codec(0, "JPEG"));
        v0.audioCodecs = AudioCodecImpl.getAvailableCodecs();
    }

    protected void setDesktopBounds(Rectangle rectangle) {
        this.library.getFunction("avSetDesktopBounds").invoke(null, (Parameter)new Int32(rectangle.x), (Parameter)new Int32(rectangle.y), (Parameter)new Int32(rectangle.width), (Parameter)new Int32(rectangle.height));
    }

    protected void setFullscreen(boolean bl2) {
        this.library.getFunction("avSetFullscreen").invoke(null, (Parameter)new Int32(bl2 ? 1 : 0));
    }

    protected void setWindowId(dn dn2) {
        this.library.getFunction("avSetWindowId").invoke(null, (Parameter)dn2);
    }

    protected void setCaptureMouseToNativeController(boolean bl2) {
    }

    protected void setPathToNativeController(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        this.a = string;
        this.library.getFunction("avSetPath").invoke(null, (Parameter)new AnsiString("file:" + string));
    }

    protected void setFramerateToNativeController(int n2) {
        this.library.getFunction("avSetFramerate").invoke(null, (Parameter)new Int((long)n2));
    }

    protected void setQualityToNativeController(int n2) {
        float f2 = (float)n2 / 100.0f;
        this.library.getFunction("avSetQuality").invoke(null, (Parameter)new cf(f2));
    }

    protected void setOutputDimensionsToNativeController(double d2, double d3) {
        DoubleFloat doubleFloat = d2 > 0.0 ? new DoubleFloat(d2) : new DoubleFloat(0.0);
        DoubleFloat doubleFloat2 = d3 > 0.0 ? new DoubleFloat(d3) : new DoubleFloat(0.0);
        this.library.getFunction("avSetOutputDimentions").invoke(null, (Parameter)doubleFloat, (Parameter)doubleFloat2);
    }

    protected void setCaptureAreaToNativeController(Rectangle rectangle) {
        this.library.getFunction("avSetCaptureArea").invoke(null, (Parameter)new SingleFloat((double)rectangle.x), (Parameter)new SingleFloat((double)rectangle.y), (Parameter)new SingleFloat((double)rectangle.width), (Parameter)new SingleFloat((double)rectangle.height));
    }

    protected void setCodecToNativeController(Codec object) {
        object = ((Format)object).getName();
        this.library.getFunction("avSetCodec").invoke(null, (Parameter)new AnsiString((String)object));
    }

    protected void startNativeController() {
        this.library.getFunction("avStart").invoke(null);
    }

    protected void stopNativeController() {
        this.library.getFunction("avStop").invoke(null);
    }

    protected void initNativeController(VideoSource videoSource, boolean bl2) {
        File file = new File(this.a);
        if (file.exists()) {
            throw new IllegalStateException("Cannot create video file " + this.a + " the target is corrupted");
        }
        if (videoSource instanceof Desktop || videoSource instanceof FullScreen || videoSource instanceof WindowSource) {
            this.library.getFunction("avInitForDesktopCapturing").invoke(null, (Parameter)new Bool(bl2));
            return;
        }
        if (videoSource instanceof LionVideoDevice) {
            videoSource = (LionVideoDevice)videoSource;
            this.library.getFunction("avInitForCameraCapturing").invoke(null, (Parameter)new Bool(bl2), (Parameter)new AnsiString(((LionVideoDevice)videoSource).getDeviceId()));
            return;
        }
        throw new IllegalStateException("Unsupported source: " + videoSource);
    }

    protected void setKeyFrameToNativeController(int n2) {
        this.library.getFunction("avSetKeyFrame").invoke(null, (Parameter)new Int((long)n2));
    }

    protected void setAudioInput(AudioSource audioSource) {
        audioSource = (AudioSourceImpl)audioSource;
        this.library.getFunction("avSetAudioInput").invoke(null, (Parameter)new AnsiString(((AudioSourceImpl)audioSource).getUid()));
    }

    protected void setAudioCodec(int n2) {
        this.library.getFunction("avSetAudioCodec").invoke(null, (Parameter)new Int((long)n2));
    }

    protected void setAudioBitRate(int n2) {
        this.library.getFunction("avSetAudioBitRate").invoke(null, (Parameter)new Int((long)n2));
    }

    protected void setAudioSampleRate(double d2) {
        this.library.getFunction("avSetAudioSampleRate").invoke(null, (Parameter)new SingleFloat(d2));
    }

    protected void setAudioChannels(int n2) {
        this.library.getFunction("avSetAudioChannels").invoke(null, (Parameter)new Int((long)n2));
    }

    protected void setAudioVBR(boolean bl2) {
        this.library.getFunction("avSetAudioVBR").invoke(null, (Parameter)new Bool(bl2));
    }
}

