/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.image.operation.controllers;

import com.teamdev.jxcapture.image.operation.events.CaptureListener;
import com.teamdev.jxcapture.image.operation.painters.SelectionPainter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public abstract class SelectionController {
    protected CaptureListener captureListener;

    protected SelectionController() {
    }

    public abstract boolean onKeyAction(KeyEvent var1);

    public abstract boolean onMouseAction(MouseEvent var1);

    public abstract SelectionPainter getSelectionPainter();

    public void activate(CaptureListener captureListener) {
        ((SelectionController)this).captureListener = captureListener;
        if ((this = ((SelectionController)this).getSelectionPainter()) != null) {
            this.selectionStart();
        }
    }

    protected void fireCompleteAction() {
        Object object = this.getSelectionPainter();
        if (object != null) {
            object.selectionEnd();
            object = object.getSelectedArea();
            this.captureListener.complete((BufferedImage)object);
        }
    }

    protected void fireCancelAction() {
        SelectionPainter selectionPainter = this.getSelectionPainter();
        if (selectionPainter != null) {
            selectionPainter.selectionEnd();
        }
        if (this.captureListener != null) {
            this.captureListener.cancel();
        }
    }
}

