/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.image.operation;

import com.teamdev.jxcapture.image.operation.events.CaptureListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;

public abstract class CaptureOperation {
    private final List a = new LinkedList();

    protected CaptureOperation() {
    }

    public abstract void execute();

    public void addCaptureListener(CaptureListener captureListener) {
        if (!this.a.contains(captureListener)) {
            this.a.add(captureListener);
        }
    }

    public void removeCaptureListener(CaptureListener captureListener) {
        this.a.remove(captureListener);
    }

    public CaptureListener[] getCaptureListeners() {
        return this.a.toArray(new CaptureListener[this.a.size()]);
    }

    protected void fireCaptureStartEvent() {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            CaptureListener captureListener = (CaptureListener)this.a.get(i2);
            captureListener.start();
        }
    }

    protected void fireCaptureCancelEvent() {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            CaptureListener captureListener = (CaptureListener)this.a.get(i2);
            captureListener.cancel();
        }
    }

    protected void fireCaptureCompleteEvent(BufferedImage bufferedImage) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            CaptureListener captureListener = (CaptureListener)this.a.get(i2);
            captureListener.complete(bufferedImage);
        }
    }
}

