/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture.image.operation;

import com.teamdev.jxcapture.ImageCapture;
import com.teamdev.jxcapture.image.operation.ActiveWindowCapture;
import com.teamdev.jxcapture.image.operation.CaptureOperation;
import com.teamdev.jxcapture.image.operation.DesktopCapture;
import com.teamdev.jxcapture.image.operation.ObjectCapture;
import com.teamdev.jxcapture.image.operation.RegionCapture;
import com.teamdev.jxcapture.image.operation.ScreenObjectCapture;
import com.teamdev.jxcapture.image.operation.controllers.RegionController;
import com.teamdev.jxcapture.image.operation.controllers.ScreenObjectController;
import com.teamdev.jxcapture.image.operation.controllers.SelectionController;
import com.teamdev.jxcapture.image.operation.events.CaptureListener;
import com.teamdev.jxcapture.image.operation.painters.RegionPainter;
import com.teamdev.jxcapture.image.operation.painters.ScreenObjectPainter;
import com.teamdev.jxcapture.image.operation.painters.SelectionPainter;
import com.teamdev.jxdesktop.WindowManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Capture {
    private final ImageCapture a;

    public Capture() {
        WindowManager.getInstance();
        this.a = ImageCapture.create();
    }

    public static void captureDesktop(CaptureListener captureListener) {
        DesktopCapture desktopCapture = new DesktopCapture();
        desktopCapture.addCaptureListener(captureListener);
        ((CaptureOperation)desktopCapture).execute();
    }

    public static void captureActiveWindow(CaptureListener captureListener) {
        ActiveWindowCapture activeWindowCapture = new ActiveWindowCapture();
        activeWindowCapture.addCaptureListener(captureListener);
        ((CaptureOperation)activeWindowCapture).execute();
    }

    public static void captureRegion(CaptureListener captureListener) {
        Object object = new RegionPainter();
        object = new RegionController((SelectionPainter)object);
        object = new RegionCapture((SelectionController)object);
        ((CaptureOperation)object).addCaptureListener(captureListener);
        ((CaptureOperation)object).execute();
    }

    public static void captureScreenObject(CaptureListener captureListener) {
        Object object = new ScreenObjectPainter();
        object = new ScreenObjectController((SelectionPainter)object);
        object = new ScreenObjectCapture((SelectionController)object);
        ((CaptureOperation)object).addCaptureListener(captureListener);
        ((CaptureOperation)object).execute();
    }

    public static void captureObject(CaptureListener captureListener) {
        ObjectCapture objectCapture = new ObjectCapture();
        objectCapture.addCaptureListener(captureListener);
        ((CaptureOperation)objectCapture).execute();
    }

    public BufferedImage createScreenCapture(Rectangle rectangle) {
        this.a.setCaptureArea(rectangle);
        return this.a.takeSnapshot().getImage();
    }
}

