/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture;

import com.teamdev.jxcapture.BaseEncodingParameters;
import com.teamdev.jxcapture.Codec;
import com.teamdev.jxcapture.EncodingParameters;
import com.teamdev.jxcapture.audio.AudioCodec;
import com.teamdev.jxcapture.audio.AudioSource;
import com.teamdev.jxcapture.ba;
import com.teamdev.jxcapture.bv;
import com.teamdev.jxcapture.video.Desktop;
import com.teamdev.jxcapture.video.Framerate;
import com.teamdev.jxcapture.video.VideoFormat;
import com.teamdev.jxcapture.video.VideoSource;
import com.teamdev.jxdesktop.OS;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VideoCapture
extends bv {
    private static Boolean a = null;
    private final Object b = new Object();
    private EncodingParameters c;
    private boolean d = false;
    private VideoSource e = null;
    private AudioSource f = null;
    private Framerate g;
    public static final String PROPERTY_FRAMERATE = "Framerate";
    public static final String PROPERTY_VIDEO_SOURCE = "VideoSource";
    public static final String PROPERTY_AUDIO_SOURCE = "AudioSource";

    protected VideoCapture() {
        this.setVideoSource(new Desktop());
    }

    protected VideoCapture(VideoSource videoSource) {
        this();
        this.setVideoSource(videoSource);
    }

    public boolean isStarted() {
        return this.d;
    }

    public EncodingParameters getEncodingParameters() {
        return this.c;
    }

    public void setEncodingParameters(EncodingParameters encodingParameters) {
        if (this.d) {
            throw new IllegalStateException("Video capture is already started");
        }
        this.validate(encodingParameters);
        this.c = encodingParameters;
    }

    public Framerate getFramerate() {
        return this.g;
    }

    public void setFramerate(int n2) {
        this.setFramerate(new Framerate(n2));
    }

    public void setFramerate(Framerate framerate) {
        if (framerate == null) {
            throw new NullPointerException("Framerate is null");
        }
        if (!framerate.equals(this.g)) {
            Framerate framerate2 = this.g;
            this.g = framerate;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FRAMERATE, framerate2, this.g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(EncodingParameters object) {
        this.setEncodingParameters((EncodingParameters)object);
        object = this.b;
        synchronized (object) {
            this.doStart();
            this.d = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.b;
        synchronized (object) {
            this.doStart();
            this.d = true;
            return;
        }
    }

    protected void validate(EncodingParameters object) {
        if (object == null) {
            throw new NullPointerException("Encoding settings are not specified");
        }
        if ((object = ((BaseEncodingParameters)object).getCodec()) == null) {
            throw new IllegalArgumentException("Video codec is not specified");
        }
        if (!(this = ((VideoCapture)this).getVideoCodecs()).contains(object)) {
            throw new IllegalArgumentException("The specified video codec: " + object + " is not supported by");
        }
    }

    protected abstract void doStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (!this.d) {
            throw new IllegalStateException("Video capture is not started yet");
        }
        Object object = this.b;
        synchronized (object) {
            this.doStop();
            this.d = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        if (!this.d) {
            throw new IllegalStateException("Video capture is not started yet");
        }
        Object object = this.b;
        synchronized (object) {
            this.doPause();
            return;
        }
    }

    protected abstract void doPause();

    protected abstract void doStop();

    public abstract VideoFormat getVideoFormat();

    public abstract List<Codec> getVideoCodecs();

    public abstract List<AudioCodec> getAudioCodecs();

    public static VideoCapture create(VideoFormat videoFormat) {
        if (videoFormat == null) {
            throw new NullPointerException("Video format cannot be null");
        }
        Iterator iterator = OS.detect();
        iterator = ba.a((OS)((Object)iterator));
        Logger logger = LoggerFactory.getLogger(VideoCapture.class);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (ba)iterator.next();
            logger.debug("VideoCaptureModule: " + object);
            VideoFormat videoFormat2 = ((VideoCapture)(object = ((ba)object).a())).getVideoFormat();
            if (!videoFormat.equals(videoFormat2)) continue;
            return object;
        }
        return null;
    }

    public static VideoCapture create() {
        Object object = OS.detect();
        if (object instanceof OS.Windows) {
            object = VideoFormat.WMV;
        } else if (object instanceof OS.MacOSX) {
            object = VideoFormat.MP4;
        } else if (object instanceof OS.Linux) {
            object = VideoFormat.AVI;
        } else {
            throw new IllegalStateException("Unsupported platform");
        }
        return VideoCapture.create((VideoFormat)object);
    }

    public static List<VideoFormat> getAvailableFormats() {
        LinkedList<VideoFormat> linkedList = new LinkedList<VideoFormat>();
        Object object = ba.a(OS.detect());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ba)object.next();
            object2 = ((ba)object2).a();
            object2 = ((VideoCapture)object2).getVideoFormat();
            linkedList.add((VideoFormat)object2);
        }
        return linkedList;
    }

    public AudioSource getAudioSource() {
        return this.f;
    }

    public void setAudioSource(AudioSource audioSource) {
        if (audioSource == null) {
            AudioSource audioSource2 = this.f;
            this.f = audioSource;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_AUDIO_SOURCE, audioSource2, audioSource);
            return;
        }
        if (!audioSource.equals(this.f)) {
            AudioSource audioSource3 = this.f;
            this.f = audioSource;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_AUDIO_SOURCE, audioSource3, audioSource);
        }
    }

    public VideoSource getVideoSource() {
        return this.e;
    }

    public void setVideoSource(VideoSource videoSource) {
        if (videoSource == null) {
            throw new NullPointerException("Video source is null");
        }
        if (!videoSource.equals(this.e)) {
            VideoSource videoSource2 = this.e;
            this.e = videoSource;
            this.setCaptureArea(new Rectangle(videoSource.getSize()));
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VIDEO_SOURCE, videoSource2, videoSource);
        }
    }

    public static boolean isAvailable() {
        if (a == null) {
            Object object = OS.detect();
            a = !(object = ba.a((OS)object)).isEmpty();
        }
        return a;
    }
}

