/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxcapture;

import com.teamdev.jxcapture.CompressionQuality;
import com.teamdev.jxcapture.InterpolationMode;
import com.teamdev.jxcapture.UIElementSource;
import com.teamdev.jxcapture.bv;
import com.teamdev.jxcapture.es;
import com.teamdev.jxcapture.image.ImageFormat;
import com.teamdev.jxcapture.image.ImageSource;
import com.teamdev.jxcapture.image.linux.LinuxImageCapture;
import com.teamdev.jxcapture.image.mac.MacOSImageCapture;
import com.teamdev.jxcapture.image.win.WindowsImageCapture;
import com.teamdev.jxcapture.video.Desktop;
import com.teamdev.jxdesktop.OS;
import com.teamdev.jxdesktop.UIElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageCapture
extends bv {
    private static final Logger a = LoggerFactory.getLogger(ImageCapture.class);
    public static final String PROPERTY_IMAGE_SOURCE = "ImageCapture.ImageSource";
    private ImageSource b = null;
    private PropertyChangeListener c;

    protected ImageCapture() {
        this.setImageSource(new Desktop());
        this.c = new es(this);
    }

    public static ImageCapture create() {
        OS oS = OS.detect();
        if (oS instanceof OS.Windows) {
            return new WindowsImageCapture();
        }
        if (oS instanceof OS.MacOSX) {
            return new MacOSImageCapture();
        }
        if (oS instanceof OS.Linux) {
            return new LinuxImageCapture();
        }
        throw new RuntimeException("Unsupported operating system.");
    }

    public static ImageCapture create(UIElement uIElement) {
        ImageCapture imageCapture = ImageCapture.create();
        imageCapture.setImageSource(new UIElementSource(uIElement));
        return imageCapture;
    }

    public static ImageCapture create(ImageSource imageSource) {
        ImageCapture imageCapture = ImageCapture.create();
        imageCapture.setImageSource(imageSource);
        return imageCapture;
    }

    public abstract ImageCapture takeSnapshot();

    public abstract BufferedImage getImage();

    public abstract ImageCapture resize(Dimension var1, InterpolationMode var2);

    public ImageCapture resize(Dimension dimension) {
        return this.resize(dimension, InterpolationMode.Default);
    }

    public abstract boolean save(File var1, ImageFormat var2, CompressionQuality var3) throws IOException;

    public boolean save(File file, ImageFormat imageFormat) throws IOException {
        return this.save(file, imageFormat, CompressionQuality.BEST);
    }

    public abstract void copyToClipboard();

    public abstract void release();

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public ImageSource getImageSource() {
        return this.b;
    }

    public void setImageSource(ImageSource imageSource) {
        if (imageSource == null) {
            throw new NullPointerException("Image source is null");
        }
        if (!imageSource.equals(this.b)) {
            ImageSource imageSource2 = this.b;
            if (imageSource2 != null) {
                imageSource2.deactivate();
                imageSource2.removePropertyChangeListener(this.c);
            }
            this.b = imageSource;
            imageSource.activate();
            imageSource.addPropertyChangeListener("ImageSource.Size", this.c);
            this.setCaptureArea(new Rectangle(this.b.getSize()));
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_IMAGE_SOURCE, imageSource2, imageSource);
        }
    }

    static /* synthetic */ ImageSource a(ImageCapture imageCapture) {
        return imageCapture.b;
    }

    static /* synthetic */ Logger a() {
        return a;
    }
}

