/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;

public abstract class ContextHelper {
    public static SearchFactoryImplementor getSearchFactory(Session session) {
        return ContextHelper.getSearchFactoryBySessionImplementor((SessionImplementor)session);
    }

    public static SearchFactoryImplementor getSearchFactoryBySessionImplementor(SessionImplementor session) {
        return ContextHelper.getSearchFactoryBySFI(session.getFactory());
    }

    public static SearchFactoryImplementor getSearchFactoryBySFI(SessionFactoryImplementor sfi) {
        EventListenerRegistry service = (EventListenerRegistry)sfi.getServiceRegistry().getService(EventListenerRegistry.class);
        Iterable listeners = service.getEventListenerGroup(EventType.POST_INSERT).listeners();
        FullTextIndexEventListener listener = null;
        for (PostInsertEventListener candidate : listeners) {
            if (!(candidate instanceof FullTextIndexEventListener)) continue;
            listener = (FullTextIndexEventListener)candidate;
            break;
        }
        if (listener == null) {
            throw new HibernateException("Hibernate Search Event listeners not configured, please check the reference documentation and the application's hibernate.cfg.xml");
        }
        return listener.getSearchFactoryImplementor();
    }
}

