/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SecondLevelCacheObjectsInitializer
implements ObjectsInitializer {
    private static final Log log = LoggerFactory.make();
    private final ObjectsInitializer delegate;

    public SecondLevelCacheObjectsInitializer(ObjectsInitializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        boolean traceEnabled = log.isTraceEnabled();
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            if (traceEnabled) {
                log.tracef("No object to initialize", maxResults);
            }
            return;
        }
        ArrayList<EntityInfo> remainingEntityInfos = new ArrayList<EntityInfo>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, session)) {
                boolean isIn2LCache = session.getSessionFactory().getCache().containsEntity(entityInfo.getClazz(), entityInfo.getId());
                if (isIn2LCache) {
                    try {
                        session.get(entityInfo.getClazz(), entityInfo.getId());
                    }
                    catch (ObjectNotFoundException onfe) {
                        remainingEntityInfos.add(entityInfo);
                    }
                    continue;
                }
                remainingEntityInfos.add(entityInfo);
                continue;
            }
            remainingEntityInfos.add(entityInfo);
        }
        int remainingSize = remainingEntityInfos.size();
        if (traceEnabled) {
            log.tracef("Initialized %d objects out of %d in the second level cache", maxResults - remainingSize, maxResults);
        }
        if (remainingSize > 0) {
            this.delegate.initializeObjects(remainingEntityInfos.toArray(new EntityInfo[remainingSize]), criteria, entityType, searchFactoryImplementor, timeoutManager, session);
        }
    }
}

