/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.javaserialization.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Add;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Delete;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Message;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Operation;
import org.hibernate.search.indexes.serialization.javaserialization.impl.OptimizeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.PurgeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableBinaryField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableCustomFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDocument;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDoubleField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFloatField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableIntField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableLongField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableReaderField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableStringField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableTokenStreamField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Update;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.spi.Serializer;

public class JavaSerializationSerializer
implements Serializer {
    private Serializable id;
    private Set<Operation> ops;
    private Set<SerializableFieldable> serialFields;
    private SerializableDocument currentDocument;

    @Override
    public void luceneWorks(List<LuceneWork> works) {
        this.ops = new HashSet<Operation>(works.size());
    }

    @Override
    public void addOptimizeAll() {
        this.ops.add(new OptimizeAll());
    }

    @Override
    public void addPurgeAll(String entityClassName) {
        this.ops.add(new PurgeAll(entityClassName));
    }

    @Override
    public void addIdSerializedInJava(byte[] id) {
        this.id = id;
    }

    @Override
    public void addIdAsInteger(int id) {
        this.id = Integer.valueOf(id);
    }

    @Override
    public void addIdAsLong(long id) {
        this.id = Long.valueOf(id);
    }

    @Override
    public void addIdAsFloat(float id) {
        this.id = Float.valueOf(id);
    }

    @Override
    public void addIdAsDouble(double id) {
        this.id = Double.valueOf(id);
    }

    @Override
    public void addIdAsString(String id) {
        this.id = id;
    }

    @Override
    public void addDelete(String entityClassName) {
        this.ops.add(new Delete(entityClassName, this.id));
    }

    @Override
    public void addAdd(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Add(entityClassName, this.id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    @Override
    public void addUpdate(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Update(entityClassName, this.id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    @Override
    public byte[] serialize() {
        Message message = new Message(this.ops);
        return SerializationHelper.toByteArray(message);
    }

    @Override
    public void fields(List<Fieldable> fields) {
        this.serialFields = new HashSet<SerializableFieldable>(fields.size());
    }

    @Override
    public void addIntNumericField(int value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableIntField(value, context));
    }

    @Override
    public void addLongNumericField(long value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableLongField(value, context));
    }

    @Override
    public void addFloatNumericField(float value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableFloatField(value, context));
    }

    @Override
    public void addDoubleNumericField(double value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableDoubleField(value, context));
    }

    @Override
    public void addFieldWithBinaryData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableBinaryField(luceneFieldContext));
    }

    @Override
    public void addFieldWithStringData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableStringField(luceneFieldContext));
    }

    @Override
    public void addFieldWithTokenStreamData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableTokenStreamField(luceneFieldContext));
    }

    @Override
    public void addFieldWithSerializableReaderData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableReaderField(luceneFieldContext));
    }

    @Override
    public void addFieldWithSerializableFieldable(byte[] fieldable) {
        this.serialFields.add(new SerializableCustomFieldable(fieldable));
    }

    @Override
    public void addDocument(float boost) {
        this.currentDocument = new SerializableDocument(this.serialFields, boost);
    }

    private void clearDocument() {
        this.currentDocument = null;
        this.serialFields = null;
    }
}

