/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.Helper;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.HibernateSessionLoadingInitializer;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class EntityConsumerLuceneWorkProducer
implements SessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<?>> source;
    private final SessionFactory sessionFactory;
    private final Map<Class<?>, EntityIndexBinder> entityIndexBinders;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final CountDownLatch producerEndSignal;
    private final BatchBackend backend;
    private final ErrorHandler errorHandler;

    public EntityConsumerLuceneWorkProducer(ProducerConsumerQueue<List<?>> entitySource, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CountDownLatch producerEndSignal, SearchFactoryImplementor searchFactory, CacheMode cacheMode, BatchBackend backend, ErrorHandler errorHandler) {
        this.source = entitySource;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.producerEndSignal = producerEndSignal;
        this.cacheMode = cacheMode;
        this.backend = backend;
        this.errorHandler = errorHandler;
        this.entityIndexBinders = searchFactory.getIndexBindingForEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session upperSession) {
        Session session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openSession();
        }
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
            transaction.begin();
            this.indexAllQueue(session);
            transaction.commit();
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
        finally {
            this.producerEndSignal.countDown();
            if (upperSession == null) {
                session.close();
            }
        }
        log.debug("finished");
    }

    private void indexAllQueue(Session session) {
        HibernateSessionLoadingInitializer sessionInitializer = new HibernateSessionLoadingInitializer((SessionImplementor)session);
        try {
            List<?> takeList;
            ContextualExceptionBridgeHelper contextualBridge = new ContextualExceptionBridgeHelper();
            while ((takeList = this.source.take()) != null) {
                log.tracef("received a list of objects to index: %s", takeList);
                for (Object take : takeList) {
                    session.buildLockRequest(LockOptions.NONE).lock(take);
                    this.index(take, session, sessionInitializer, contextualBridge);
                    this.monitor.documentsBuilt(1);
                    session.clear();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(Object entity, Session session, InstanceInitializer sessionInitializer, ConversionContext conversionContext) throws InterruptedException {
        Serializable id = session.getIdentifier(entity);
        Class<Object> clazz = HibernateHelper.getClass(entity);
        EntityIndexBinder entityIndexBinding = this.entityIndexBinders.get(clazz);
        if (entityIndexBinding == null) {
            return;
        }
        EntityIndexingInterceptor<?> interceptor = entityIndexBinding.getEntityIndexingInterceptor();
        if (interceptor != null) {
            IndexingOverride onAdd = interceptor.onAdd(entity);
            switch (onAdd) {
                case REMOVE: 
                case SKIP: {
                    return;
                }
            }
        }
        DocumentBuilderIndexedEntity<?> docBuilder = entityIndexBinding.getDocumentBuilder();
        TwoWayFieldBridge idBridge = docBuilder.getIdBridge();
        conversionContext.pushProperty(docBuilder.getIdKeywordName());
        String idInString = null;
        try {
            idInString = conversionContext.setClass(clazz).twoWayConversionContext(idBridge).objectToString(id);
        }
        finally {
            conversionContext.popProperty();
        }
        AddLuceneWork addWork = docBuilder.createAddWork(clazz, entity, id, idInString, sessionInitializer, conversionContext);
        this.backend.enqueueAsyncWork(addWork);
    }
}

