/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.properties;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction;
import com.intellij.execution.testframework.JavaAwareTestConsoleProperties;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConsoleProperties
extends JavaAwareTestConsoleProperties<JUnitConfiguration> {
    public JUnitConsoleProperties(@NotNull JUnitConfiguration configuration, Executor executor) {
        super("JUnit", (RunConfiguration)configuration, executor);
    }

    @NotNull
    protected GlobalSearchScope initScope() {
        JUnitConfiguration.Data persistentData = ((JUnitConfiguration)this.getConfiguration()).getPersistentData();
        String testObject = persistentData.TEST_OBJECT;
        if ("category".equals(testObject) || "pattern".equals(testObject) || "package".equals(testObject)) {
            SourceScope sourceScope = persistentData.getScope().getSourceScope(this.getConfiguration());
            return sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)this.getProject());
        }
        return super.initScope();
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target) {
        super.appendAdditionalActions(actionGroup, parent, target);
        actionGroup.add((AnAction)this.createIncludeNonStartedInRerun(target));
    }

    public SMTestLocator getTestLocator() {
        return JavaTestLocator.INSTANCE;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return new RerunFailedTestsAction((ComponentContainer)consoleView, (TestConsoleProperties)this);
    }
}

