/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JUnitExternalLibraryDescriptor
extends ExternalLibraryDescriptor {
    public static final ExternalLibraryDescriptor JUNIT3 = new JUnitExternalLibraryDescriptor("3"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return Collections.singletonList(JavaSdkUtil.getJunit3JarPath());
        }
    };
    public static final ExternalLibraryDescriptor JUNIT4 = new JUnitExternalLibraryDescriptor("4"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return JavaSdkUtil.getJUnit4JarPaths();
        }
    };
    private final String myVersion;

    public JUnitExternalLibraryDescriptor(String version) {
        super("junit", "junit", version + ".0", version + ".999");
        this.myVersion = version;
    }

    public String getPresentableName() {
        return "JUnit" + this.myVersion;
    }
}

