/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ClassesWithAnnotatedMembersSearch;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchorUtil;
import com.intellij.psi.stubsHierarchy.impl.HierarchyService;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    public static boolean findAllTestClasses(final TestClassFilter testClassFilter, final Set<PsiClass> found) {
        SingleClassHierarchy symbols;
        PsiManager manager = testClassFilter.getPsiManager();
        final Project project = manager.getProject();
        GlobalSearchScope projectScopeWithoutLibraries = GlobalSearchScope.projectScope((Project)project);
        final GlobalSearchScope scope = projectScopeWithoutLibraries.intersectWith(testClassFilter.getScope());
        SingleClassHierarchy singleClassHierarchy = symbols = HierarchyService.isEnabled() ? HierarchyService.instance((Project)project).getSingleClassHierarchy() : null;
        if (symbols != null) {
            SmartClassAnchor[] candidates;
            for (SmartClassAnchor smartClassAnchor : candidates = symbols.getAllSubtypes(testClassFilter.getBase())) {
                PsiClass aClass;
                int fileId = smartClassAnchor.myFileId;
                VirtualFile file = PersistentFS.getInstance().findFileById(fileId);
                if (file == null || !scope.contains(file) || !testClassFilter.isAccepted(aClass = ClassAnchorUtil.retrieveInReadAction((Project)project, (SmartClassAnchor)smartClassAnchor))) continue;
                found.add(aClass);
            }
        } else {
            ClassInheritorsSearch.search((PsiClass)testClassFilter.getBase(), (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass aClass) {
                    if (testClassFilter.isAccepted(aClass)) {
                        found.add(aClass);
                    }
                    return true;
                }
            }));
        }
        PsiMethod[] suiteMethods = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return PsiShortNamesCache.getInstance((Project)project).getMethodsByName("suite", scope);
            }
        });
        for (SmartClassAnchor smartClassAnchor : suiteMethods) {
            ApplicationManager.getApplication().runReadAction(new Runnable((PsiMethod)smartClassAnchor, testClassFilter, found){
                final /* synthetic */ PsiMethod val$method;
                final /* synthetic */ TestClassFilter val$testClassFilter;
                final /* synthetic */ Set val$found;
                {
                    this.val$method = psiMethod;
                    this.val$testClassFilter = testClassFilter;
                    this.val$found = set;
                }

                @Override
                public void run() {
                    PsiClass containingClass = this.val$method.getContainingClass();
                    if (containingClass == null) {
                        return;
                    }
                    if (containingClass instanceof PsiAnonymousClass) {
                        return;
                    }
                    if (containingClass.hasModifierProperty("abstract")) {
                        return;
                    }
                    if (containingClass.getContainingClass() != null && !containingClass.hasModifierProperty("static")) {
                        return;
                    }
                    if (JUnitUtil.isSuiteMethod((PsiMethod)this.val$method) && this.val$testClassFilter.isAccepted(containingClass)) {
                        this.val$found.add(containingClass);
                    }
                }
            });
        }
        HashSet processed = ContainerUtil.newHashSet();
        boolean hasJunit4 = ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.Test", true, symbols);
        return hasJunit4 |= ConfigurationUtil.addAnnotatedMethodsAnSubclasses(manager, scope, testClassFilter, found, processed, "org.junit.runner.RunWith", false, symbols);
    }

    private static boolean addAnnotatedMethodsAnSubclasses(final PsiManager manager, final GlobalSearchScope scope, final TestClassFilter testClassFilter, final Set<PsiClass> found, final Set<PsiClass> processed, final String annotation, boolean isMethod, final SingleClassHierarchy table) {
        final Ref isJUnit4 = new Ref((Object)Boolean.FALSE);
        PsiClass testAnnotation = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(annotation, GlobalSearchScope.allScope((Project)manager.getProject()));
            }
        });
        if (testAnnotation != null) {
            ClassesWithAnnotatedMembersSearch.search((PsiClass)testAnnotation, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject())).forEach((Processor)new Processor<PsiClass>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiClass annotated) {
                    AccessToken token = ReadAction.start();
                    try {
                        if (!processed.add(annotated)) {
                            boolean bl = true;
                            return bl;
                        }
                        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)annotated);
                        if (file != null && scope.contains(file) && testClassFilter.isAccepted(annotated)) {
                            if (!found.add(annotated)) {
                                boolean bl = true;
                                return bl;
                            }
                            isJUnit4.set((Object)Boolean.TRUE);
                        }
                    }
                    finally {
                        token.finish();
                    }
                    if (table != null) {
                        SmartClassAnchor[] candidates;
                        for (final SmartClassAnchor candidate : candidates = table.getAllSubtypes(annotated)) {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    PsiClass aClass;
                                    int fileId = candidate.myFileId;
                                    VirtualFile file = PersistentFS.getInstance().findFileById(fileId);
                                    if (file != null && scope.contains(file) && testClassFilter.isAccepted(aClass = ClassAnchorUtil.retrieve((Project)manager.getProject(), (SmartClassAnchor)candidate))) {
                                        found.add(aClass);
                                        processed.add(aClass);
                                        isJUnit4.set((Object)Boolean.TRUE);
                                    }
                                }
                            });
                        }
                    } else {
                        ClassInheritorsSearch.search((PsiClass)annotated, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiClass>(){

                            public boolean processInReadAction(PsiClass aClass) {
                                if (testClassFilter.isAccepted(aClass)) {
                                    found.add(aClass);
                                    processed.add(aClass);
                                    isJUnit4.set((Object)Boolean.TRUE);
                                }
                                return true;
                            }
                        });
                    }
                    return true;
                }
            });
        }
        return (Boolean)isJUnit4.get();
    }
}

