/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Log;
import android.util.Printer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class FastPrintWriter
extends PrintWriter {
    private final int mBufferLen;
    private final char[] mText;
    private int mPos;
    private final OutputStream mOutputStream;
    private final boolean mAutoFlush;
    private final String mSeparator;
    private final Writer mWriter;
    private final Printer mPrinter;
    private CharsetEncoder mCharset;
    private final ByteBuffer mBytes;
    private boolean mIoError;

    public FastPrintWriter(OutputStream out) {
        this(out, false, 8192);
    }

    public FastPrintWriter(OutputStream out, boolean autoFlush) {
        this(out, autoFlush, 8192);
    }

    public FastPrintWriter(OutputStream out, boolean autoFlush, int bufferLen) {
        super((Writer)new DummyWriter(), autoFlush);
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = ByteBuffer.allocate(this.mBufferLen);
        this.mOutputStream = out;
        this.mWriter = null;
        this.mPrinter = null;
        this.mAutoFlush = autoFlush;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    public FastPrintWriter(Writer wr) {
        this(wr, false, 8192);
    }

    public FastPrintWriter(Writer wr, boolean autoFlush) {
        this(wr, autoFlush, 8192);
    }

    public FastPrintWriter(Writer wr, boolean autoFlush, int bufferLen) {
        super((Writer)new DummyWriter(), autoFlush);
        if (wr == null) {
            throw new NullPointerException("wr is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = wr;
        this.mPrinter = null;
        this.mAutoFlush = autoFlush;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    public FastPrintWriter(Printer pr) {
        this(pr, 512);
    }

    public FastPrintWriter(Printer pr, int bufferLen) {
        super((Writer)new DummyWriter(), true);
        if (pr == null) {
            throw new NullPointerException("pr is null");
        }
        this.mBufferLen = bufferLen;
        this.mText = new char[bufferLen];
        this.mBytes = null;
        this.mOutputStream = null;
        this.mWriter = null;
        this.mPrinter = pr;
        this.mAutoFlush = true;
        this.mSeparator = System.lineSeparator();
        this.initDefaultEncoder();
    }

    private void initEncoder(String csn) throws UnsupportedEncodingException {
        try {
            this.mCharset = Charset.forName(csn).newEncoder();
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(csn);
        }
        this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkError() {
        this.flush();
        Object object = this.lock;
        synchronized (object) {
            return this.mIoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setError() {
        Object object = this.lock;
        synchronized (object) {
            this.mIoError = true;
        }
    }

    private void initDefaultEncoder() {
        this.mCharset = Charset.defaultCharset().newEncoder();
        this.mCharset.onMalformedInput(CodingErrorAction.REPLACE);
        this.mCharset.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private void appendLocked(char c) throws IOException {
        int pos = this.mPos;
        if (pos >= this.mBufferLen - 1) {
            this.flushLocked();
            pos = this.mPos;
        }
        this.mText[pos] = c;
        this.mPos = pos + 1;
    }

    private void appendLocked(String str, int i, int length) throws IOException {
        int BUFFER_LEN = this.mBufferLen;
        if (length > BUFFER_LEN) {
            int end = i + length;
            while (i < end) {
                int next = i + BUFFER_LEN;
                this.appendLocked(str, i, next < end ? BUFFER_LEN : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > BUFFER_LEN) {
            this.flushLocked();
            pos = this.mPos;
        }
        str.getChars(i, i + length, this.mText, pos);
        this.mPos = pos + length;
    }

    private void appendLocked(char[] buf, int i, int length) throws IOException {
        int BUFFER_LEN = this.mBufferLen;
        if (length > BUFFER_LEN) {
            int end = i + length;
            while (i < end) {
                int next = i + BUFFER_LEN;
                this.appendLocked(buf, i, next < end ? BUFFER_LEN : end - i);
                i = next;
            }
            return;
        }
        int pos = this.mPos;
        if (pos + length > BUFFER_LEN) {
            this.flushLocked();
            pos = this.mPos;
        }
        System.arraycopy(buf, i, this.mText, pos, length);
        this.mPos = pos + length;
    }

    private void flushBytesLocked() throws IOException {
        int position;
        if (!this.mIoError && (position = this.mBytes.position()) > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, position);
            this.mBytes.clear();
        }
    }

    private void flushLocked() throws IOException {
        if (this.mPos > 0) {
            if (this.mOutputStream != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult result = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (!this.mIoError) {
                    if (result.isError()) {
                        throw new IOException(result.toString());
                    }
                    if (!result.isOverflow()) break;
                    this.flushBytesLocked();
                    result = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                if (!this.mIoError) {
                    this.flushBytesLocked();
                    this.mOutputStream.flush();
                }
            } else if (this.mWriter != null) {
                if (!this.mIoError) {
                    this.mWriter.write(this.mText, 0, this.mPos);
                    this.mWriter.flush();
                }
            } else {
                int nonEolOff;
                int len;
                int sepLen = this.mSeparator.length();
                int n = len = sepLen < this.mPos ? sepLen : this.mPos;
                for (nonEolOff = 0; nonEolOff < len && this.mText[this.mPos - 1 - nonEolOff] == this.mSeparator.charAt(this.mSeparator.length() - 1 - nonEolOff); ++nonEolOff) {
                }
                if (nonEolOff >= this.mPos) {
                    this.mPrinter.println("");
                } else {
                    this.mPrinter.println(new String(this.mText, 0, this.mPos - nonEolOff));
                }
            }
            this.mPos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.flushLocked();
                if (!this.mIoError) {
                    if (this.mOutputStream != null) {
                        this.mOutputStream.flush();
                    } else if (this.mWriter != null) {
                        this.mWriter.flush();
                    }
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.flushLocked();
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                } else if (this.mWriter != null) {
                    this.mWriter.close();
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(char[] charArray) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(charArray, 0, charArray.length);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(char ch) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(ch);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String str) {
        if (str == null) {
            str = String.valueOf(null);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, 0, str.length());
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    @Override
    public void print(int inum) {
        if (inum == 0) {
            this.print("0");
        } else {
            super.print(inum);
        }
    }

    @Override
    public void print(long lnum) {
        if (lnum == 0L) {
            this.print("0");
        } else {
            super.print(lnum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(this.mSeparator, 0, this.mSeparator.length());
                if (this.mAutoFlush) {
                    this.flushLocked();
                }
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    @Override
    public void println(int inum) {
        if (inum == 0) {
            this.println("0");
        } else {
            super.println(inum);
        }
    }

    @Override
    public void println(long lnum) {
        if (lnum == 0L) {
            this.println("0");
        } else {
            super.println(lnum);
        }
    }

    @Override
    public void println(char[] chars) {
        this.print(chars);
        this.println();
    }

    @Override
    public void println(char c) {
        this.print(c);
        this.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(buf, offset, count);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked((char)oneChar);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, 0, str.length());
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.appendLocked(str, offset, count);
            }
            catch (IOException e) {
                Log.w("FastPrintWriter", "Write failure", e);
                this.setError();
            }
        }
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }

    private static class DummyWriter
    extends Writer {
        private DummyWriter() {
        }

        @Override
        public void close() throws IOException {
            UnsupportedOperationException ex = new UnsupportedOperationException("Shouldn't be here");
            throw ex;
        }

        @Override
        public void flush() throws IOException {
            this.close();
        }

        @Override
        public void write(char[] buf, int offset, int count) throws IOException {
            this.close();
        }
    }
}

