/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import com.android.internal.transition.TransitionConstants;

public class EpicenterTranslateClipReveal
extends Visibility {
    private static final String PROPNAME_CLIP = "android:epicenterReveal:clip";
    private static final String PROPNAME_BOUNDS = "android:epicenterReveal:bounds";
    private static final String PROPNAME_TRANSLATE_X = "android:epicenterReveal:translateX";
    private static final String PROPNAME_TRANSLATE_Y = "android:epicenterReveal:translateY";
    private static final String PROPNAME_TRANSLATE_Z = "android:epicenterReveal:translateZ";
    private static final String PROPNAME_Z = "android:epicenterReveal:z";
    private final TimeInterpolator mInterpolatorX;
    private final TimeInterpolator mInterpolatorY;
    private final TimeInterpolator mInterpolatorZ;

    public EpicenterTranslateClipReveal() {
        this.mInterpolatorX = null;
        this.mInterpolatorY = null;
        this.mInterpolatorZ = null;
    }

    public EpicenterTranslateClipReveal(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EpicenterTranslateClipReveal, 0, 0);
        int interpolatorX = a.getResourceId(0, 0);
        this.mInterpolatorX = interpolatorX != 0 ? AnimationUtils.loadInterpolator(context, interpolatorX) : TransitionConstants.LINEAR_OUT_SLOW_IN;
        int interpolatorY = a.getResourceId(1, 0);
        this.mInterpolatorY = interpolatorY != 0 ? AnimationUtils.loadInterpolator(context, interpolatorY) : TransitionConstants.FAST_OUT_SLOW_IN;
        int interpolatorZ = a.getResourceId(2, 0);
        this.mInterpolatorZ = interpolatorZ != 0 ? AnimationUtils.loadInterpolator(context, interpolatorZ) : TransitionConstants.FAST_OUT_SLOW_IN;
        a.recycle();
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        super.captureStartValues(transitionValues);
        this.captureValues(transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        super.captureEndValues(transitionValues);
        this.captureValues(transitionValues);
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (view.getVisibility() == 8) {
            return;
        }
        Rect bounds = new Rect(0, 0, view.getWidth(), view.getHeight());
        values.values.put(PROPNAME_BOUNDS, bounds);
        values.values.put(PROPNAME_TRANSLATE_X, Float.valueOf(view.getTranslationX()));
        values.values.put(PROPNAME_TRANSLATE_Y, Float.valueOf(view.getTranslationY()));
        values.values.put(PROPNAME_TRANSLATE_Z, Float.valueOf(view.getTranslationZ()));
        values.values.put(PROPNAME_Z, Float.valueOf(view.getZ()));
        Rect clip = view.getClipBounds();
        values.values.put(PROPNAME_CLIP, clip);
    }

    @Override
    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (endValues == null) {
            return null;
        }
        Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        Rect startBounds = this.getEpicenterOrCenter(endBounds);
        float startX = startBounds.centerX() - endBounds.centerX();
        float startY = startBounds.centerY() - endBounds.centerY();
        float startZ = 0.0f - ((Float)endValues.values.get(PROPNAME_Z)).floatValue();
        view.setTranslationX(startX);
        view.setTranslationY(startY);
        view.setTranslationZ(startZ);
        float endX = ((Float)endValues.values.get(PROPNAME_TRANSLATE_X)).floatValue();
        float endY = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Y)).floatValue();
        float endZ = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Z)).floatValue();
        Rect endClip = this.getBestRect(endValues);
        Rect startClip = this.getEpicenterOrCenter(endClip);
        view.setClipBounds(startClip);
        State startStateX = new State(startClip.left, startClip.right, startX);
        State endStateX = new State(endClip.left, endClip.right, endX);
        State startStateY = new State(startClip.top, startClip.bottom, startY);
        State endStateY = new State(endClip.top, endClip.bottom, endY);
        return EpicenterTranslateClipReveal.createRectAnimator(view, startStateX, startStateY, startZ, endStateX, endStateY, endZ, endValues, this.mInterpolatorX, this.mInterpolatorY, this.mInterpolatorZ);
    }

    @Override
    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null) {
            return null;
        }
        Rect startBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        Rect endBounds = this.getEpicenterOrCenter(startBounds);
        float endX = endBounds.centerX() - startBounds.centerX();
        float endY = endBounds.centerY() - startBounds.centerY();
        float endZ = 0.0f - ((Float)startValues.values.get(PROPNAME_Z)).floatValue();
        float startX = ((Float)endValues.values.get(PROPNAME_TRANSLATE_X)).floatValue();
        float startY = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Y)).floatValue();
        float startZ = ((Float)endValues.values.get(PROPNAME_TRANSLATE_Z)).floatValue();
        Rect startClip = this.getBestRect(startValues);
        Rect endClip = this.getEpicenterOrCenter(startClip);
        view.setClipBounds(startClip);
        State startStateX = new State(startClip.left, startClip.right, startX);
        State endStateX = new State(endClip.left, endClip.right, endX);
        State startStateY = new State(startClip.top, startClip.bottom, startY);
        State endStateY = new State(endClip.top, endClip.bottom, endY);
        return EpicenterTranslateClipReveal.createRectAnimator(view, startStateX, startStateY, startZ, endStateX, endStateY, endZ, endValues, this.mInterpolatorX, this.mInterpolatorY, this.mInterpolatorZ);
    }

    private Rect getEpicenterOrCenter(Rect bestRect) {
        Rect epicenter = this.getEpicenter();
        if (epicenter != null) {
            return epicenter;
        }
        int centerX = bestRect.centerX();
        int centerY = bestRect.centerY();
        return new Rect(centerX, centerY, centerX, centerY);
    }

    private Rect getBestRect(TransitionValues values) {
        Rect clipRect = (Rect)values.values.get(PROPNAME_CLIP);
        if (clipRect == null) {
            return (Rect)values.values.get(PROPNAME_BOUNDS);
        }
        return clipRect;
    }

    private static Animator createRectAnimator(final View view, State startX, State startY, float startZ, State endX, State endY, float endZ, TransitionValues endValues, TimeInterpolator interpolatorX, TimeInterpolator interpolatorY, TimeInterpolator interpolatorZ) {
        StateEvaluator evaluator = new StateEvaluator();
        ObjectAnimator animZ = ObjectAnimator.ofFloat(view, View.TRANSLATION_Z, startZ, endZ);
        if (interpolatorZ != null) {
            animZ.setInterpolator(interpolatorZ);
        }
        StateProperty propX = new StateProperty('x');
        ObjectAnimator animX = ObjectAnimator.ofObject(view, propX, evaluator, startX, endX);
        if (interpolatorX != null) {
            animX.setInterpolator(interpolatorX);
        }
        StateProperty propY = new StateProperty('y');
        ObjectAnimator animY = ObjectAnimator.ofObject(view, propY, evaluator, startY, endY);
        if (interpolatorY != null) {
            animY.setInterpolator(interpolatorY);
        }
        final Rect terminalClip = (Rect)endValues.values.get(PROPNAME_CLIP);
        AnimatorListenerAdapter animatorListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                view.setClipBounds(terminalClip);
            }
        };
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(animX, animY, animZ);
        animSet.addListener(animatorListener);
        return animSet;
    }

    private static class StateProperty
    extends Property<View, State> {
        public static final char TARGET_X = 'x';
        public static final char TARGET_Y = 'y';
        private final Rect mTempRect = new Rect();
        private final State mTempState = new State();
        private final int mTargetDimension;

        public StateProperty(char targetDimension) {
            super(State.class, "state_" + targetDimension);
            this.mTargetDimension = targetDimension;
        }

        @Override
        public State get(View object) {
            Rect tempRect = this.mTempRect;
            if (!object.getClipBounds(tempRect)) {
                tempRect.setEmpty();
            }
            State tempState = this.mTempState;
            if (this.mTargetDimension == 120) {
                tempState.trans = object.getTranslationX();
                tempState.lower = tempRect.left + (int)tempState.trans;
                tempState.upper = tempRect.right + (int)tempState.trans;
            } else {
                tempState.trans = object.getTranslationY();
                tempState.lower = tempRect.top + (int)tempState.trans;
                tempState.upper = tempRect.bottom + (int)tempState.trans;
            }
            return tempState;
        }

        @Override
        public void set(View object, State value) {
            Rect tempRect = this.mTempRect;
            if (object.getClipBounds(tempRect)) {
                if (this.mTargetDimension == 120) {
                    tempRect.left = value.lower - (int)value.trans;
                    tempRect.right = value.upper - (int)value.trans;
                } else {
                    tempRect.top = value.lower - (int)value.trans;
                    tempRect.bottom = value.upper - (int)value.trans;
                }
                object.setClipBounds(tempRect);
            }
            if (this.mTargetDimension == 120) {
                object.setTranslationX(value.trans);
            } else {
                object.setTranslationY(value.trans);
            }
        }
    }

    private static class StateEvaluator
    implements TypeEvaluator<State> {
        private final State mTemp = new State();

        private StateEvaluator() {
        }

        @Override
        public State evaluate(float fraction2, State startValue, State endValue) {
            this.mTemp.upper = startValue.upper + (int)((float)(endValue.upper - startValue.upper) * fraction2);
            this.mTemp.lower = startValue.lower + (int)((float)(endValue.lower - startValue.lower) * fraction2);
            this.mTemp.trans = startValue.trans + (float)((int)((endValue.trans - startValue.trans) * fraction2));
            return this.mTemp;
        }
    }

    private static class State {
        int lower;
        int upper;
        float trans;

        public State() {
        }

        public State(int lower, int upper, float trans) {
            this.lower = lower;
            this.upper = upper;
            this.trans = trans;
        }
    }
}

