/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.BatteryStats;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import java.util.List;

public class SensorPowerCalculator
extends PowerCalculator {
    private final List<Sensor> mSensors;
    private final double mGpsPowerOn;

    public SensorPowerCalculator(PowerProfile profile, SensorManager sensorManager) {
        this.mSensors = sensorManager.getSensorList(-1);
        this.mGpsPowerOn = profile.getAveragePower("gps.on");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
        int NSE = sensorStats.size();
        block3: for (int ise = 0; ise < NSE; ++ise) {
            BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
            int sensorHandle = sensorStats.keyAt(ise);
            BatteryStats.Timer timer = sensor.getSensorTime();
            long sensorTime = timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
            switch (sensorHandle) {
                case -10000: {
                    app.gpsTimeMs = sensorTime;
                    app.gpsPowerMah = (double)app.gpsTimeMs * this.mGpsPowerOn / 3600000.0;
                    continue block3;
                }
                default: {
                    int sensorsCount = this.mSensors.size();
                    for (int i = 0; i < sensorsCount; ++i) {
                        Sensor s = this.mSensors.get(i);
                        if (s.getHandle() != sensorHandle) continue;
                        app.sensorPowerMah += (double)((float)sensorTime * s.getPower() / 3600000.0f);
                        continue block3;
                    }
                }
            }
        }
    }
}

