/*
 * Decompiled with CFR 0.152.
 */
package android.os.health;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.health.TimerStat;
import android.util.ArrayMap;
import java.util.Arrays;
import java.util.Map;

public class HealthStats {
    private String mDataType;
    private int[] mTimerKeys;
    private int[] mTimerCounts;
    private long[] mTimerTimes;
    private int[] mMeasurementKeys;
    private long[] mMeasurementValues;
    private int[] mStatsKeys;
    private ArrayMap<String, HealthStats>[] mStatsValues;
    private int[] mTimersKeys;
    private ArrayMap<String, TimerStat>[] mTimersValues;
    private int[] mMeasurementsKeys;
    private ArrayMap<String, Long>[] mMeasurementsValues;

    private HealthStats() {
        throw new RuntimeException("unsupported");
    }

    public HealthStats(Parcel in) {
        int i;
        this.mDataType = in.readString();
        int count = in.readInt();
        this.mTimerKeys = new int[count];
        this.mTimerCounts = new int[count];
        this.mTimerTimes = new long[count];
        for (i = 0; i < count; ++i) {
            this.mTimerKeys[i] = in.readInt();
            this.mTimerCounts[i] = in.readInt();
            this.mTimerTimes[i] = in.readLong();
        }
        count = in.readInt();
        this.mMeasurementKeys = new int[count];
        this.mMeasurementValues = new long[count];
        for (i = 0; i < count; ++i) {
            this.mMeasurementKeys[i] = in.readInt();
            this.mMeasurementValues[i] = in.readLong();
        }
        count = in.readInt();
        this.mStatsKeys = new int[count];
        this.mStatsValues = new ArrayMap[count];
        for (i = 0; i < count; ++i) {
            this.mStatsKeys[i] = in.readInt();
            this.mStatsValues[i] = HealthStats.createHealthStatsMap(in);
        }
        count = in.readInt();
        this.mTimersKeys = new int[count];
        this.mTimersValues = new ArrayMap[count];
        for (i = 0; i < count; ++i) {
            this.mTimersKeys[i] = in.readInt();
            this.mTimersValues[i] = HealthStats.createParcelableMap(in, TimerStat.CREATOR);
        }
        count = in.readInt();
        this.mMeasurementsKeys = new int[count];
        this.mMeasurementsValues = new ArrayMap[count];
        for (i = 0; i < count; ++i) {
            this.mMeasurementsKeys[i] = in.readInt();
            this.mMeasurementsValues[i] = HealthStats.createLongsMap(in);
        }
    }

    public String getDataType() {
        return this.mDataType;
    }

    public boolean hasTimer(int key) {
        return HealthStats.getIndex(this.mTimerKeys, key) >= 0;
    }

    public TimerStat getTimer(int key) {
        int index = HealthStats.getIndex(this.mTimerKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad timer key dataType=" + this.mDataType + " key=" + key);
        }
        return new TimerStat(this.mTimerCounts[index], this.mTimerTimes[index]);
    }

    public int getTimerCount(int key) {
        int index = HealthStats.getIndex(this.mTimerKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad timer key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mTimerCounts[index];
    }

    public long getTimerTime(int key) {
        int index = HealthStats.getIndex(this.mTimerKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad timer key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mTimerTimes[index];
    }

    public int getTimerKeyCount() {
        return this.mTimerKeys.length;
    }

    public int getTimerKeyAt(int index) {
        return this.mTimerKeys[index];
    }

    public boolean hasMeasurement(int key) {
        return HealthStats.getIndex(this.mMeasurementKeys, key) >= 0;
    }

    public long getMeasurement(int key) {
        int index = HealthStats.getIndex(this.mMeasurementKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad measurement key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mMeasurementValues[index];
    }

    public int getMeasurementKeyCount() {
        return this.mMeasurementKeys.length;
    }

    public int getMeasurementKeyAt(int index) {
        return this.mMeasurementKeys[index];
    }

    public boolean hasStats(int key) {
        return HealthStats.getIndex(this.mStatsKeys, key) >= 0;
    }

    public Map<String, HealthStats> getStats(int key) {
        int index = HealthStats.getIndex(this.mStatsKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad stats key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mStatsValues[index];
    }

    public int getStatsKeyCount() {
        return this.mStatsKeys.length;
    }

    public int getStatsKeyAt(int index) {
        return this.mStatsKeys[index];
    }

    public boolean hasTimers(int key) {
        return HealthStats.getIndex(this.mTimersKeys, key) >= 0;
    }

    public Map<String, TimerStat> getTimers(int key) {
        int index = HealthStats.getIndex(this.mTimersKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad timers key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mTimersValues[index];
    }

    public int getTimersKeyCount() {
        return this.mTimersKeys.length;
    }

    public int getTimersKeyAt(int index) {
        return this.mTimersKeys[index];
    }

    public boolean hasMeasurements(int key) {
        return HealthStats.getIndex(this.mMeasurementsKeys, key) >= 0;
    }

    public Map<String, Long> getMeasurements(int key) {
        int index = HealthStats.getIndex(this.mMeasurementsKeys, key);
        if (index < 0) {
            throw new IndexOutOfBoundsException("Bad measurements key dataType=" + this.mDataType + " key=" + key);
        }
        return this.mMeasurementsValues[index];
    }

    public int getMeasurementsKeyCount() {
        return this.mMeasurementsKeys.length;
    }

    public int getMeasurementsKeyAt(int index) {
        return this.mMeasurementsKeys[index];
    }

    private static int getIndex(int[] keys, int key) {
        return Arrays.binarySearch(keys, key);
    }

    private static ArrayMap<String, HealthStats> createHealthStatsMap(Parcel in) {
        int count = in.readInt();
        ArrayMap<String, HealthStats> result = new ArrayMap<String, HealthStats>(count);
        for (int i = 0; i < count; ++i) {
            result.put(in.readString(), new HealthStats(in));
        }
        return result;
    }

    private static <T extends Parcelable> ArrayMap<String, T> createParcelableMap(Parcel in, Parcelable.Creator<T> creator) {
        int count = in.readInt();
        ArrayMap<String, T> result = new ArrayMap<String, T>(count);
        for (int i = 0; i < count; ++i) {
            result.put(in.readString(), creator.createFromParcel(in));
        }
        return result;
    }

    private static ArrayMap<String, Long> createLongsMap(Parcel in) {
        int count = in.readInt();
        ArrayMap<String, Long> result = new ArrayMap<String, Long>(count);
        for (int i = 0; i < count; ++i) {
            result.put(in.readString(), in.readLong());
        }
        return result;
    }
}

