/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityThread;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Process;

public abstract class Vibrator {
    private final String mPackageName;

    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
    }

    public abstract boolean hasVibrator();

    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    public void vibrate(long milliseconds, AudioAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, milliseconds, attributes);
    }

    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, pattern, repeat, attributes);
    }

    public abstract void vibrate(int var1, String var2, long var3, AudioAttributes var5);

    public abstract void vibrate(int var1, String var2, long[] var3, int var4, AudioAttributes var5);

    public abstract void cancel();
}

