/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class RadioModule
extends RadioTuner {
    private long mNativeContext = 0L;
    private int mId;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    static final int EVENT_HW_FAILURE = 0;
    static final int EVENT_CONFIG = 1;
    static final int EVENT_ANTENNA = 2;
    static final int EVENT_TUNED = 3;
    static final int EVENT_METADATA = 4;
    static final int EVENT_TA = 5;
    static final int EVENT_AF_SWITCH = 6;
    static final int EVENT_EA = 7;
    static final int EVENT_CONTROL = 100;
    static final int EVENT_SERVER_DIED = 101;

    RadioModule(int moduleId, RadioManager.BandConfig config, boolean withAudio, RadioTuner.Callback callback, Handler handler) {
        this.mId = moduleId;
        this.mEventHandlerDelegate = new NativeEventHandlerDelegate(callback, handler);
        this.native_setup(new WeakReference<RadioModule>(this), config, withAudio);
    }

    private void native_setup(Object object, RadioManager.BandConfig bandConfig, boolean bl) {
        OverrideMethod.invokeV("android.hardware.radio.RadioModule#native_setup(Ljava/lang/Object;Landroid/hardware/radio/RadioManager$BandConfig;Z)V", true, this);
    }

    protected void finalize() {
        this.native_finalize();
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.hardware.radio.RadioModule#native_finalize()V", true, this);
    }

    boolean initCheck() {
        return this.mNativeContext != 0L;
    }

    @Override
    public void close() {
        OverrideMethod.invokeV("android.hardware.radio.RadioModule#close()V", true, this);
    }

    @Override
    public int setConfiguration(RadioManager.BandConfig bandConfig) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#setConfiguration(Landroid/hardware/radio/RadioManager$BandConfig;)I", true, this);
    }

    @Override
    public int getConfiguration(RadioManager.BandConfig[] bandConfigArray) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#getConfiguration([Landroid/hardware/radio/RadioManager$BandConfig;)I", true, this);
    }

    @Override
    public int setMute(boolean bl) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#setMute(Z)I", true, this);
    }

    @Override
    public boolean getMute() {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#getMute()Z", true, this) != 0;
    }

    @Override
    public int step(int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#step(IZ)I", true, this);
    }

    @Override
    public int scan(int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#scan(IZ)I", true, this);
    }

    @Override
    public int tune(int n, int n2) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#tune(II)I", true, this);
    }

    @Override
    public int cancel() {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#cancel()I", true, this);
    }

    @Override
    public int getProgramInformation(RadioManager.ProgramInfo[] programInfoArray) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#getProgramInformation([Landroid/hardware/radio/RadioManager$ProgramInfo;)I", true, this);
    }

    @Override
    public boolean isAntennaConnected() {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#isAntennaConnected()Z", true, this) != 0;
    }

    @Override
    public boolean hasControl() {
        return OverrideMethod.invokeI("android.hardware.radio.RadioModule#hasControl()Z", true, this) != 0;
    }

    private static void postEventFromNative(Object module_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        RadioModule module = (RadioModule)((WeakReference)module_ref).get();
        if (module == null) {
            return;
        }
        NativeEventHandlerDelegate delegate = module.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.handler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        NativeEventHandlerDelegate(final RadioTuner.Callback callback, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.getMainLooper();
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    block0 : switch (msg.what) {
                        case 0: {
                            if (callback == null) break;
                            callback.onError(0);
                            break;
                        }
                        case 1: {
                            RadioManager.BandConfig config = (RadioManager.BandConfig)msg.obj;
                            switch (msg.arg1) {
                                case 0: {
                                    if (callback == null) break block0;
                                    callback.onConfigurationChanged(config);
                                    break;
                                }
                                default: {
                                    if (callback == null) break block0;
                                    callback.onError(4);
                                    break;
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (callback == null) break;
                            callback.onAntennaState(msg.arg2 == 1);
                            break;
                        }
                        case 3: 
                        case 6: {
                            RadioManager.ProgramInfo info = (RadioManager.ProgramInfo)msg.obj;
                            switch (msg.arg1) {
                                case 0: {
                                    if (callback == null) break block0;
                                    callback.onProgramInfoChanged(info);
                                    break;
                                }
                                case -110: {
                                    if (callback == null) break block0;
                                    callback.onError(3);
                                    break;
                                }
                                default: {
                                    if (callback == null) break block0;
                                    callback.onError(2);
                                    break;
                                }
                            }
                            break;
                        }
                        case 4: {
                            RadioMetadata metadata = (RadioMetadata)msg.obj;
                            if (callback == null) break;
                            callback.onMetadataChanged(metadata);
                            break;
                        }
                        case 5: {
                            if (callback == null) break;
                            callback.onTrafficAnnouncement(msg.arg2 == 1);
                            break;
                        }
                        case 7: {
                            if (callback != null) {
                                callback.onEmergencyAnnouncement(msg.arg2 == 1);
                            }
                        }
                        case 100: {
                            if (callback == null) break;
                            callback.onControlChanged(msg.arg2 == 1);
                            break;
                        }
                        case 101: {
                            if (callback == null) break;
                            callback.onError(1);
                            break;
                        }
                    }
                }
            } : null;
        }

        Handler handler() {
            return this.mHandler;
        }
    }
}

