/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BidiRenderer;
import android.graphics.ColorFilter_Delegate;
import android.graphics.FontFamily_Delegate;
import android.graphics.MaskFilter_Delegate;
import android.graphics.Paint;
import android.graphics.PathEffect_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.Rasterizer_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader_Delegate;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Typeface_Delegate;
import android.graphics.Xfermode_Delegate;
import android.text.TextUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import libcore.util.NativeAllocationRegistry_Delegate;

public class Paint_Delegate {
    private static final DelegateManager<Paint_Delegate> sManager = new DelegateManager<Paint_Delegate>(Paint_Delegate.class);
    private static long sFinalizer = -1L;
    private List<FontInfo> mFonts;
    private int mFlags;
    private int mColor;
    private int mStyle;
    private int mCap;
    private int mJoin;
    private int mTextAlign;
    private Typeface_Delegate mTypeface;
    private float mStrokeWidth;
    private float mStrokeMiter;
    private float mTextSize;
    private float mTextScaleX;
    private float mTextSkewX;
    private int mHintingMode = 1;
    private int mHyphenEdit;
    private float mLetterSpacing;
    private FontFamily_Delegate.FontVariant mFontVariant = FontFamily_Delegate.FontVariant.COMPACT;
    private Xfermode_Delegate mXfermode;
    private ColorFilter_Delegate mColorFilter;
    private Shader_Delegate mShader;
    private PathEffect_Delegate mPathEffect;
    private MaskFilter_Delegate mMaskFilter;
    private Rasterizer_Delegate mRasterizer;
    private Locale mLocale = Locale.getDefault();
    public long mNativeTypeface;

    public static Paint_Delegate getDelegate(long native_paint) {
        return sManager.getDelegate(native_paint);
    }

    public List<FontInfo> getFonts() {
        return this.mFonts;
    }

    public boolean isAntiAliased() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isFilterBitmap() {
        return (this.mFlags & 2) != 0;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int getColor() {
        return this.mColor;
    }

    public int getAlpha() {
        return this.mColor >>> 24;
    }

    public void setAlpha(int alpha) {
        this.mColor = alpha << 24 | this.mColor & 0xFFFFFF;
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public float getJavaStrokeMiter() {
        return this.mStrokeMiter;
    }

    public int getJavaCap() {
        switch (Paint.sCapArray[this.mCap]) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
        }
        return 2;
    }

    public int getJavaJoin() {
        switch (Paint.sJoinArray[this.mJoin]) {
            default: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case BEVEL: 
        }
        return 2;
    }

    public Stroke getJavaStroke() {
        if (this.mPathEffect != null) {
            if (this.mPathEffect.isSupported()) {
                Stroke stroke = this.mPathEffect.getStroke(this);
                assert (stroke != null);
                if (stroke != null) {
                    return stroke;
                }
            } else {
                Bridge.getLog().fidelityWarning("patheffect", this.mPathEffect.getSupportMessage(), null, null);
            }
        }
        return new BasicStroke(this.getStrokeWidth(), this.getJavaCap(), this.getJavaJoin(), this.getJavaStrokeMiter());
    }

    public Xfermode_Delegate getXfermode() {
        return this.mXfermode;
    }

    public ColorFilter_Delegate getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(long colorFilterPtr) {
        this.mColorFilter = ColorFilter_Delegate.getDelegate(colorFilterPtr);
    }

    public void setShader(long shaderPtr) {
        this.mShader = Shader_Delegate.getDelegate(shaderPtr);
    }

    public Shader_Delegate getShader() {
        return this.mShader;
    }

    public MaskFilter_Delegate getMaskFilter() {
        return this.mMaskFilter;
    }

    public Rasterizer_Delegate getRasterizer() {
        return this.mRasterizer;
    }

    @LayoutlibDelegate
    static int nGetFlags(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.mFlags;
    }

    @LayoutlibDelegate
    static void nSetFlags(Paint thisPaint, long nativePaint, int flags) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFlags = flags;
    }

    @LayoutlibDelegate
    static void nSetFilterBitmap(Paint thisPaint, long nativePaint, boolean filter) {
        Paint_Delegate.setFlag(nativePaint, 2, filter);
    }

    @LayoutlibDelegate
    static int nGetHinting(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1;
        }
        return delegate.mHintingMode;
    }

    @LayoutlibDelegate
    static void nSetHinting(Paint thisPaint, long nativePaint, int mode) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mHintingMode = mode;
    }

    @LayoutlibDelegate
    static void nSetAntiAlias(Paint thisPaint, long nativePaint, boolean aa) {
        Paint_Delegate.setFlag(nativePaint, 1, aa);
    }

    @LayoutlibDelegate
    static void nSetSubpixelText(Paint thisPaint, long nativePaint, boolean subpixelText) {
        Paint_Delegate.setFlag(nativePaint, 128, subpixelText);
    }

    @LayoutlibDelegate
    static void nSetUnderlineText(Paint thisPaint, long nativePaint, boolean underlineText) {
        Paint_Delegate.setFlag(nativePaint, 8, underlineText);
    }

    @LayoutlibDelegate
    static void nSetStrikeThruText(Paint thisPaint, long nativePaint, boolean strikeThruText) {
        Paint_Delegate.setFlag(nativePaint, 16, strikeThruText);
    }

    @LayoutlibDelegate
    static void nSetFakeBoldText(Paint thisPaint, long nativePaint, boolean fakeBoldText) {
        Paint_Delegate.setFlag(nativePaint, 32, fakeBoldText);
    }

    @LayoutlibDelegate
    static void nSetDither(Paint thisPaint, long nativePaint, boolean dither) {
        Paint_Delegate.setFlag(nativePaint, 4, dither);
    }

    @LayoutlibDelegate
    static void nSetLinearText(Paint thisPaint, long nativePaint, boolean linearText) {
        Paint_Delegate.setFlag(nativePaint, 64, linearText);
    }

    @LayoutlibDelegate
    static int nGetColor(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.mColor;
    }

    @LayoutlibDelegate
    static void nSetColor(Paint thisPaint, long nativePaint, int color2) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mColor = color2;
    }

    @LayoutlibDelegate
    static int nGetAlpha(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.getAlpha();
    }

    @LayoutlibDelegate
    static void nSetAlpha(Paint thisPaint, long nativePaint, int a) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.setAlpha(a);
    }

    @LayoutlibDelegate
    static float nGetStrokeWidth(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mStrokeWidth;
    }

    @LayoutlibDelegate
    static void nSetStrokeWidth(Paint thisPaint, long nativePaint, float width) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mStrokeWidth = width;
    }

    @LayoutlibDelegate
    static float nGetStrokeMiter(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mStrokeMiter;
    }

    @LayoutlibDelegate
    static void nSetStrokeMiter(Paint thisPaint, long nativePaint, float miter) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mStrokeMiter = miter;
    }

    @LayoutlibDelegate
    static void nSetShadowLayer(long paint, float radius, float dx, float dy, int color2) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.setShadowLayer is not supported.", null, null);
    }

    @LayoutlibDelegate
    static boolean nHasShadowLayer(long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.hasShadowLayer is not supported.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean nIsElegantTextHeight(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        return delegate != null && delegate.mFontVariant == FontFamily_Delegate.FontVariant.ELEGANT;
    }

    @LayoutlibDelegate
    static void nSetElegantTextHeight(Paint thisPaint, long nativePaint, boolean elegant) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFontVariant = elegant ? FontFamily_Delegate.FontVariant.ELEGANT : FontFamily_Delegate.FontVariant.COMPACT;
    }

    @LayoutlibDelegate
    static float nGetTextSize(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextSize;
    }

    @LayoutlibDelegate
    static void nSetTextSize(Paint thisPaint, long nativePaint, float textSize) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        if (delegate.mTextSize != textSize) {
            delegate.mTextSize = textSize;
            delegate.updateFontObject();
        }
    }

    @LayoutlibDelegate
    static float nGetTextScaleX(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextScaleX;
    }

    @LayoutlibDelegate
    static void nSetTextScaleX(Paint thisPaint, long nativePaint, float scaleX) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        if (delegate.mTextScaleX != scaleX) {
            delegate.mTextScaleX = scaleX;
            delegate.updateFontObject();
        }
    }

    @LayoutlibDelegate
    static float nGetTextSkewX(Paint thisPaint, long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 1.0f;
        }
        return delegate.mTextSkewX;
    }

    @LayoutlibDelegate
    static void nSetTextSkewX(Paint thisPaint, long nativePaint, float skewX) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        if (delegate.mTextSkewX != skewX) {
            delegate.mTextSkewX = skewX;
            delegate.updateFontObject();
        }
    }

    @LayoutlibDelegate
    static float nAscent(Paint thisPaint, long nativePaint, long nativeTypeface) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            return -javaMetrics.getAscent();
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static float nDescent(Paint thisPaint, long nativePaint, long nativeTypeface) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            return javaMetrics.getDescent();
        }
        return 0.0f;
    }

    @LayoutlibDelegate
    static float nGetFontMetrics(Paint thisPaint, long nativePaint, long nativeTypeface, Paint.FontMetrics metrics) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        return delegate.getFontMetrics(metrics);
    }

    @LayoutlibDelegate
    static int nGetFontMetricsInt(Paint thisPaint, long nativePaint, long nativeTypeface, Paint.FontMetricsInt fmi) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        if (delegate.mFonts.size() > 0) {
            FontMetrics javaMetrics = delegate.mFonts.get((int)0).mMetrics;
            if (fmi != null) {
                fmi.top = -javaMetrics.getMaxAscent();
                fmi.ascent = -javaMetrics.getAscent();
                fmi.descent = javaMetrics.getDescent();
                fmi.bottom = javaMetrics.getMaxDescent();
                fmi.leading = javaMetrics.getLeading();
            }
            return javaMetrics.getHeight();
        }
        return 0;
    }

    @LayoutlibDelegate
    static int nBreakText(long nativePaint, long nativeTypeface, char[] text, int index, int count, float maxWidth, int bidiFlags, float[] measuredWidth) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        int inc = count > 0 ? 1 : -1;
        int measureIndex = 0;
        int i = index;
        while (i != index + count) {
            int end;
            int start;
            if (i < index) {
                start = i;
                end = index;
            } else {
                start = index;
                end = i;
            }
            RectF bounds = delegate.measureText(text, start, end - start + 1, null, 0, bidiFlags);
            float res = bounds.right - bounds.left;
            if (measuredWidth != null) {
                measuredWidth[measureIndex] = res;
            }
            if (res > maxWidth) {
                return measureIndex;
            }
            i += inc;
            ++measureIndex;
        }
        return measureIndex;
    }

    @LayoutlibDelegate
    static int nBreakText(long nativePaint, long nativeTypeface, String text, boolean measureForwards, float maxWidth, int bidiFlags, float[] measuredWidth) {
        return Paint_Delegate.nBreakText(nativePaint, nativeTypeface, text.toCharArray(), 0, text.length(), maxWidth, bidiFlags, measuredWidth);
    }

    @LayoutlibDelegate
    static long nInit() {
        Paint_Delegate newDelegate = new Paint_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static long nInitWithPaint(long paint) {
        Paint_Delegate delegate = sManager.getDelegate(paint);
        if (delegate == null) {
            return 0L;
        }
        Paint_Delegate newDelegate = new Paint_Delegate(delegate);
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void nReset(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.reset();
    }

    @LayoutlibDelegate
    static void nSet(long native_dst, long native_src) {
        Paint_Delegate delegate_dst = sManager.getDelegate(native_dst);
        if (delegate_dst == null) {
            return;
        }
        Paint_Delegate delegate_src = sManager.getDelegate(native_src);
        if (delegate_src == null) {
            return;
        }
        delegate_dst.set(delegate_src);
    }

    @LayoutlibDelegate
    static int nGetStyle(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mStyle;
    }

    @LayoutlibDelegate
    static void nSetStyle(long native_object, int style2) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mStyle = style2;
    }

    @LayoutlibDelegate
    static int nGetStrokeCap(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mCap;
    }

    @LayoutlibDelegate
    static void nSetStrokeCap(long native_object, int cap) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mCap = cap;
    }

    @LayoutlibDelegate
    static int nGetStrokeJoin(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mJoin;
    }

    @LayoutlibDelegate
    static void nSetStrokeJoin(long native_object, int join) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mJoin = join;
    }

    @LayoutlibDelegate
    static boolean nGetFillPath(long native_object, long src, long dst) {
        Paint_Delegate paint = sManager.getDelegate(native_object);
        if (paint == null) {
            return false;
        }
        Path_Delegate srcPath = Path_Delegate.getDelegate(src);
        if (srcPath == null) {
            return true;
        }
        Path_Delegate dstPath = Path_Delegate.getDelegate(dst);
        if (dstPath == null) {
            return true;
        }
        Stroke stroke = paint.getJavaStroke();
        Shape strokeShape = stroke.createStrokedShape(srcPath.getJavaShape());
        dstPath.setJavaShape(strokeShape);
        return true;
    }

    @LayoutlibDelegate
    static long nSetShader(long native_object, long shader) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return shader;
        }
        delegate.mShader = Shader_Delegate.getDelegate(shader);
        return shader;
    }

    @LayoutlibDelegate
    static long nSetColorFilter(long native_object, long filter) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return filter;
        }
        delegate.mColorFilter = ColorFilter_Delegate.getDelegate(filter);
        if (delegate.mColorFilter != null && !delegate.mColorFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("colorfilter", delegate.mColorFilter.getSupportMessage(), null, null);
        }
        return filter;
    }

    @LayoutlibDelegate
    static long nSetXfermode(long native_object, long xfermode) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return xfermode;
        }
        delegate.mXfermode = Xfermode_Delegate.getDelegate(xfermode);
        return xfermode;
    }

    @LayoutlibDelegate
    static long nSetPathEffect(long native_object, long effect) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return effect;
        }
        delegate.mPathEffect = PathEffect_Delegate.getDelegate(effect);
        return effect;
    }

    @LayoutlibDelegate
    static long nSetMaskFilter(long native_object, long maskfilter) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return maskfilter;
        }
        delegate.mMaskFilter = MaskFilter_Delegate.getDelegate(maskfilter);
        if (delegate.mMaskFilter != null && !delegate.mMaskFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("maskfilter", delegate.mMaskFilter.getSupportMessage(), null, null);
        }
        return maskfilter;
    }

    @LayoutlibDelegate
    static long nSetTypeface(long native_object, long typeface) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0L;
        }
        Typeface_Delegate typefaceDelegate = Typeface_Delegate.getDelegate(typeface);
        if (delegate.mTypeface != typefaceDelegate || delegate.mNativeTypeface != typeface) {
            delegate.mTypeface = Typeface_Delegate.getDelegate(typeface);
            delegate.mNativeTypeface = typeface;
            delegate.updateFontObject();
        }
        return typeface;
    }

    @LayoutlibDelegate
    static long nSetRasterizer(long native_object, long rasterizer) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return rasterizer;
        }
        delegate.mRasterizer = Rasterizer_Delegate.getDelegate(rasterizer);
        if (delegate.mRasterizer != null && !delegate.mRasterizer.isSupported()) {
            Bridge.getLog().fidelityWarning("rasterizer", delegate.mRasterizer.getSupportMessage(), null, null);
        }
        return rasterizer;
    }

    @LayoutlibDelegate
    static int nGetTextAlign(long native_object) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        return delegate.mTextAlign;
    }

    @LayoutlibDelegate
    static void nSetTextAlign(long native_object, int align) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return;
        }
        delegate.mTextAlign = align;
    }

    @LayoutlibDelegate
    static int nSetTextLocales(long native_object, String locale) {
        Paint_Delegate delegate = sManager.getDelegate(native_object);
        if (delegate == null) {
            return 0;
        }
        delegate.setTextLocale(locale);
        return 0;
    }

    @LayoutlibDelegate
    static void nSetTextLocalesByMinikinLangListId(long paintPtr, int mMinikinLangListId) {
    }

    @LayoutlibDelegate
    static float nGetTextAdvances(long native_object, long native_typeface, char[] text, int index, int count, int contextIndex, int contextCount, int bidiFlags, float[] advances, int advancesIndex) {
        Paint_Delegate delegate;
        if (advances != null) {
            for (int i = advancesIndex; i < advancesIndex + count; ++i) {
                advances[i] = 0.0f;
            }
        }
        if ((delegate = sManager.getDelegate(native_object)) == null) {
            return 0.0f;
        }
        assert (native_typeface == delegate.mNativeTypeface);
        RectF bounds = delegate.measureText(text, index, count, advances, advancesIndex, bidiFlags);
        return bounds.right - bounds.left;
    }

    @LayoutlibDelegate
    static float nGetTextAdvances(long native_object, long native_typeface, String text, int start, int end, int contextStart, int contextEnd, int bidiFlags, float[] advances, int advancesIndex) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        return Paint_Delegate.nGetTextAdvances(native_object, native_typeface, buffer, 0, count, contextStart, contextEnd - contextStart, bidiFlags, advances, advancesIndex);
    }

    @LayoutlibDelegate
    static int nGetTextRunCursor(Paint thisPaint, long native_object, char[] text, int contextStart, int contextLength, int flags, int offset, int cursorOpt) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextRunCursor is not supported.", null, null);
        return 0;
    }

    @LayoutlibDelegate
    static int nGetTextRunCursor(Paint thisPaint, long native_object, String text, int contextStart, int contextEnd, int flags, int offset, int cursorOpt) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextRunCursor is not supported.", null, null);
        return 0;
    }

    @LayoutlibDelegate
    static void nGetTextPath(long native_object, long native_typeface, int bidiFlags, char[] text, int index, int count, float x, float y, long path) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nGetTextPath(long native_object, long native_typeface, int bidiFlags, String text, int start, int end, float x, float y, long path) {
        Bridge.getLog().fidelityWarning("unsupported", "Paint.getTextPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nGetStringBounds(long nativePaint, long native_typeface, String text, int start, int end, int bidiFlags, Rect bounds) {
        Paint_Delegate.nGetCharArrayBounds(nativePaint, native_typeface, text.toCharArray(), start, end - start, bidiFlags, bounds);
    }

    @LayoutlibDelegate
    static void nGetCharArrayBounds(long nativePaint, long native_typeface, char[] text, int index, int count, int bidiFlags, Rect bounds) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        assert (native_typeface == delegate.mNativeTypeface);
        delegate.measureText(text, index, count, null, 0, bidiFlags).roundOut(bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetNativeFinalizer() {
        Class<Paint_Delegate> clazz = Paint_Delegate.class;
        synchronized (Paint_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static float nGetLetterSpacing(long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0.0f;
        }
        return delegate.mLetterSpacing;
    }

    @LayoutlibDelegate
    static void nSetLetterSpacing(long nativePaint, float letterSpacing) {
        Bridge.getLog().fidelityWarning("textRendering", "Paint.setLetterSpacing() not supported.", null, null);
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mLetterSpacing = letterSpacing;
    }

    @LayoutlibDelegate
    static void nSetFontFeatureSettings(long nativePaint, String settings) {
        Bridge.getLog().fidelityWarning("textRendering", "Paint.setFontFeatureSettings() not supported.", null, null);
    }

    @LayoutlibDelegate
    static int nGetHyphenEdit(long nativePaint) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return 0;
        }
        return delegate.mHyphenEdit;
    }

    @LayoutlibDelegate
    static void nSetHyphenEdit(long nativePaint, int hyphen) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mHyphenEdit = hyphen;
    }

    @LayoutlibDelegate
    static boolean nHasGlyph(long nativePaint, long nativeTypeface, int bidiFlags, String string2) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return false;
        }
        if (string2.length() == 0) {
            return false;
        }
        if (string2.length() > 1) {
            Bridge.getLog().fidelityWarning("textRendering", "Paint.hasGlyph() is not supported for ligatures.", null, null);
            return false;
        }
        assert (nativeTypeface == delegate.mNativeTypeface);
        Typeface_Delegate typeface_delegate = Typeface_Delegate.getDelegate(nativeTypeface);
        char c = string2.charAt(0);
        for (Font font : typeface_delegate.getFonts(delegate.mFontVariant)) {
            if (!font.canDisplay(c)) continue;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static float nGetRunAdvance(long nativePaint, long nativeTypeface, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        int count = end - start;
        float[] advances = new float[count];
        int bidiFlags = isRtl ? 5 : 4;
        Paint_Delegate.nGetTextAdvances(nativePaint, nativeTypeface, text, start, count, contextStart, contextEnd - contextStart, bidiFlags, advances, 0);
        int startOffset = offset - start;
        float sum = 0.0f;
        for (int i = 0; i < startOffset; ++i) {
            sum += advances[i];
        }
        return sum;
    }

    @LayoutlibDelegate
    static int nGetOffsetForAdvance(long nativePaint, long nativeTypeface, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float advance) {
        int i;
        int count = end - start;
        float[] advances = new float[count];
        int bidiFlags = isRtl ? 5 : 4;
        Paint_Delegate.nGetTextAdvances(nativePaint, nativeTypeface, text, start, count, contextStart, contextEnd - contextStart, bidiFlags, advances, 0);
        float sum = 0.0f;
        for (i = 0; i < count && sum < advance; sum += advances[i], ++i) {
        }
        float distanceToI = sum - advance;
        float distanceToIMinus1 = advance - (sum - advances[i]);
        return distanceToI > distanceToIMinus1 ? i : i - 1;
    }

    Paint_Delegate() {
        this.reset();
    }

    private Paint_Delegate(Paint_Delegate paint) {
        this.set(paint);
    }

    private void set(Paint_Delegate paint) {
        this.mFlags = paint.mFlags;
        this.mColor = paint.mColor;
        this.mStyle = paint.mStyle;
        this.mCap = paint.mCap;
        this.mJoin = paint.mJoin;
        this.mTextAlign = paint.mTextAlign;
        boolean needsFontUpdate = false;
        if (this.mTypeface != paint.mTypeface || this.mNativeTypeface != paint.mNativeTypeface) {
            this.mTypeface = paint.mTypeface;
            this.mNativeTypeface = paint.mNativeTypeface;
            needsFontUpdate = true;
        }
        if (this.mTextSize != paint.mTextSize) {
            this.mTextSize = paint.mTextSize;
            needsFontUpdate = true;
        }
        if (this.mTextScaleX != paint.mTextScaleX) {
            this.mTextScaleX = paint.mTextScaleX;
            needsFontUpdate = true;
        }
        if (this.mTextSkewX != paint.mTextSkewX) {
            this.mTextSkewX = paint.mTextSkewX;
            needsFontUpdate = true;
        }
        this.mStrokeWidth = paint.mStrokeWidth;
        this.mStrokeMiter = paint.mStrokeMiter;
        this.mXfermode = paint.mXfermode;
        this.mColorFilter = paint.mColorFilter;
        this.mShader = paint.mShader;
        this.mPathEffect = paint.mPathEffect;
        this.mMaskFilter = paint.mMaskFilter;
        this.mRasterizer = paint.mRasterizer;
        this.mHintingMode = paint.mHintingMode;
        if (needsFontUpdate) {
            this.updateFontObject();
        }
    }

    private void reset() {
        this.mFlags = 1280;
        this.mColor = -16777216;
        this.mStyle = Paint.Style.FILL.nativeInt;
        this.mCap = Paint.Cap.BUTT.nativeInt;
        this.mJoin = Paint.Join.MITER.nativeInt;
        this.mTextAlign = 0;
        this.mTypeface = Typeface_Delegate.getDelegate(Typeface.sDefaults[0].native_instance);
        this.mNativeTypeface = 0L;
        this.mStrokeWidth = 1.0f;
        this.mStrokeMiter = 4.0f;
        this.mTextSize = 20.0f;
        this.mTextScaleX = 1.0f;
        this.mTextSkewX = 0.0f;
        this.mXfermode = null;
        this.mColorFilter = null;
        this.mShader = null;
        this.mPathEffect = null;
        this.mMaskFilter = null;
        this.mRasterizer = null;
        this.updateFontObject();
        this.mHintingMode = 1;
    }

    private void updateFontObject() {
        if (this.mTypeface != null) {
            List<Font> fonts = this.mTypeface.getFonts(this.mFontVariant);
            if (fonts.isEmpty()) {
                this.mFonts = Collections.emptyList();
                return;
            }
            int nFonts = fonts.size();
            ArrayList<FontInfo> infoList = new ArrayList<FontInfo>(nFonts);
            for (int i = 0; i < nFonts; ++i) {
                Font font = fonts.get(i);
                if (font == null) {
                    infoList.add(null);
                    continue;
                }
                FontInfo info = new FontInfo();
                info.mFont = font.deriveFont(this.mTextSize);
                if ((double)this.mTextScaleX != 1.0 || this.mTextSkewX != 0.0f) {
                    info.mFont = info.mFont.deriveFont(new AffineTransform(this.mTextScaleX, this.mTextSkewX, 0.0f, 1.0f, 0.0f, 0.0f));
                }
                info.mMetrics = Toolkit.getDefaultToolkit().getFontMetrics(info.mFont);
                infoList.add(info);
            }
            this.mFonts = Collections.unmodifiableList(infoList);
        }
    }

    RectF measureText(char[] text, int index, int count, float[] advances, int advancesIndex, int bidiFlags) {
        return new BidiRenderer(null, this, text).renderText(index, index + count, bidiFlags, advances, advancesIndex, false);
    }

    RectF measureText(char[] text, int index, int count, float[] advances, int advancesIndex, boolean isRtl) {
        return new BidiRenderer(null, this, text).renderText(index, index + count, isRtl, advances, advancesIndex, false);
    }

    private float getFontMetrics(Paint.FontMetrics metrics) {
        if (this.mFonts.size() > 0) {
            FontMetrics javaMetrics = this.mFonts.get((int)0).mMetrics;
            if (metrics != null) {
                metrics.top = -javaMetrics.getMaxAscent();
                metrics.ascent = -javaMetrics.getAscent();
                metrics.descent = javaMetrics.getDescent();
                metrics.bottom = javaMetrics.getMaxDescent();
                metrics.leading = javaMetrics.getLeading();
            }
            return javaMetrics.getHeight();
        }
        return 0.0f;
    }

    private void setTextLocale(String locale) {
        this.mLocale = new Locale(locale);
    }

    private static void setFlag(long nativePaint, int flagMask, boolean flagValue) {
        Paint_Delegate delegate = sManager.getDelegate(nativePaint);
        if (delegate == null) {
            return;
        }
        delegate.mFlags = flagValue ? (delegate.mFlags |= flagMask) : (delegate.mFlags &= ~flagMask);
    }

    static final class FontInfo {
        Font mFont;
        FontMetrics mMetrics;

        FontInfo() {
        }
    }
}

