/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Trace;
import android.util.ArrayMap;
import com.android.internal.os.PathClassLoaderFactory;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.PathClassLoader;

class ApplicationLoaders {
    private final ArrayMap<String, ClassLoader> mLoaders = new ArrayMap();
    private static final ApplicationLoaders gApplicationLoaders = new ApplicationLoaders();

    ApplicationLoaders() {
    }

    public static ApplicationLoaders getDefault() {
        return gApplicationLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(String zip, int targetSdkVersion, boolean isBundled, String librarySearchPath, String libraryPermittedPath, ClassLoader parent) {
        ClassLoader baseParent = ClassLoader.getSystemClassLoader().getParent();
        ArrayMap<String, ClassLoader> arrayMap = this.mLoaders;
        synchronized (arrayMap) {
            if (parent == null) {
                parent = baseParent;
            }
            if (parent == baseParent) {
                ClassLoader loader = this.mLoaders.get(zip);
                if (loader != null) {
                    return loader;
                }
                Trace.traceBegin(64L, zip);
                PathClassLoader pathClassloader = PathClassLoaderFactory.createClassLoader(zip, librarySearchPath, libraryPermittedPath, parent, targetSdkVersion, isBundled);
                Trace.traceEnd(64L);
                Trace.traceBegin(64L, "setupVulkanLayerPath");
                ApplicationLoaders.setupVulkanLayerPath(pathClassloader, librarySearchPath);
                Trace.traceEnd(64L);
                this.mLoaders.put(zip, pathClassloader);
                return pathClassloader;
            }
            Trace.traceBegin(64L, zip);
            PathClassLoader pathClassloader = new PathClassLoader(zip, parent);
            Trace.traceEnd(64L);
            return pathClassloader;
        }
    }

    private static void setupVulkanLayerPath(ClassLoader classLoader, String string2) {
        OverrideMethod.invokeV("android.app.ApplicationLoaders#setupVulkanLayerPath(Ljava/lang/ClassLoader;Ljava/lang/String;)V", true, null);
    }

    void addPath(ClassLoader classLoader, String dexPath) {
        if (!(classLoader instanceof PathClassLoader)) {
            throw new IllegalStateException("class loader is not a PathClassLoader");
        }
        PathClassLoader baseDexClassLoader = (PathClassLoader)classLoader;
        baseDexClassLoader.addDexPath(dexPath);
    }
}

