/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class GenerationalClassUtil {
    private static List[] sCache = null;

    public static <T extends Serializable> List<T> loadObjects(ExtensionFilter filter) {
        if (sCache == null) {
            GenerationalClassUtil.buildCache();
        }
        return sCache[filter.ordinal()];
    }

    private static void buildCache() {
        L.d((String)"building generational class cache", (Object[])new Object[0]);
        ClassLoader classLoader = GenerationalClassUtil.class.getClassLoader();
        Preconditions.check((boolean)(classLoader instanceof URLClassLoader), (String)"Class loader must be aninstance of URLClassLoader. %s", (Object[])new Object[]{classLoader});
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        sCache = new List[ExtensionFilter.values().length];
        for (ExtensionFilter extensionFilter : ExtensionFilter.values()) {
            GenerationalClassUtil.sCache[extensionFilter.ordinal()] = new ArrayList();
        }
        for (URL uRL : urlClassLoader.getURLs()) {
            L.d((String)"checking url %s for intermediate data", (Object[])new Object[]{uRL});
            try {
                File file = new File(uRL.toURI());
                if (!file.exists()) {
                    L.d((String)"cannot load file for %s", (Object[])new Object[]{uRL});
                    continue;
                }
                if (file.isDirectory()) {
                    GenerationalClassUtil.loadFromDirectory(file);
                    continue;
                }
                GenerationalClassUtil.loadFomZipFile(file);
            }
            catch (IOException e) {
                L.d((String)"cannot open zip file from %s", (Object[])new Object[]{uRL});
            }
            catch (URISyntaxException e) {
                L.d((String)"cannot open zip file from %s", (Object[])new Object[]{uRL});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromDirectory(File directory) {
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
            for (ExtensionFilter filter : ExtensionFilter.values()) {
                if (!filter.accept(file.getName())) continue;
                FileInputStream inputStream = null;
                try {
                    inputStream = FileUtils.openInputStream((File)file);
                    Serializable item = GenerationalClassUtil.fromInputStream(inputStream);
                    if (item == null) continue;
                    sCache[filter.ordinal()].add(item);
                    L.d((String)"loaded item %s from file", (Object[])new Object[]{item});
                }
                catch (IOException e) {
                    L.e((Throwable)e, (String)"Could not merge in Bindables from %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                catch (ClassNotFoundException e) {
                    L.e((Throwable)e, (String)"Could not read Binding properties intermediate file. %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFomZipFile(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            for (ExtensionFilter filter : ExtensionFilter.values()) {
                if (!filter.accept(entry.getName())) continue;
                InputStream inputStream = null;
                try {
                    inputStream = zipFile.getInputStream(entry);
                    Serializable item = GenerationalClassUtil.fromInputStream(inputStream);
                    L.d((String)"loaded item %s from zip file", (Object[])new Object[]{item});
                    if (item == null) continue;
                    sCache[filter.ordinal()].add(item);
                }
                catch (IOException e) {
                    L.e((Throwable)e, (String)"Could not merge in Bindables from %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                catch (ClassNotFoundException e) {
                    L.e((Throwable)e, (String)"Could not read Binding properties intermediate file. %s", (Object[])new Object[]{file.getAbsolutePath()});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
    }

    private static Serializable fromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(inputStream);
        return (Serializable)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIntermediateFile(ProcessingEnvironment processingEnv, String packageName, String fileName, Serializable object) {
        ObjectOutputStream oos = null;
        try {
            FileObject intermediate = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, packageName, fileName, new Element[0]);
            OutputStream ios = intermediate.openOutputStream();
            oos = new ObjectOutputStream(ios);
            oos.writeObject(object);
            oos.close();
            L.d((String)"wrote intermediate bindable file %s %s", (Object[])new Object[]{packageName, fileName});
            IOUtils.closeQuietly((OutputStream)oos);
        }
        catch (IOException e) {
            L.e((Throwable)e, (String)"Could not write to intermediate file: %s", (Object[])new Object[]{fileName});
        }
        finally {
            IOUtils.closeQuietly(oos);
        }
    }

    public static enum ExtensionFilter {
        BR("-br.bin"),
        LAYOUT("-layoutinfo.bin"),
        SETTER_STORE("-setter_store.bin");

        private final String mExtension;

        private ExtensionFilter(String extension) {
            this.mExtension = extension;
        }

        public boolean accept(String entryName) {
            return entryName.endsWith(this.mExtension);
        }

        public String getExtension() {
            return this.mExtension;
        }
    }
}

