/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class AndroidProGuardStateStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidProGuardStateStorage");
    private final File myFile;

    public AndroidProGuardStateStorage(@NotNull File file) throws IOException {
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() throws IOException {
        FileUtil.delete((File)this.myFile);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MyState read() {
        try (DataInputStream input2222 = new DataInputStream(new FileInputStream(this.myFile));){
            boolean hasValue = input2222.readBoolean();
            if (!hasValue) {
                MyState myState = null;
                return myState;
            }
            int n = input2222.readInt();
            HashMap cfgFiles = new HashMap();
            for (int i = 0; i < n; ++i) {
                String path = input2222.readUTF();
                long timestamp = input2222.readLong();
                cfgFiles.put(path, timestamp);
            }
            MyState myState = new MyState((Map)cfgFiles);
            return myState;
        }
        catch (FileNotFoundException input2222) {
            return null;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nullable MyState state) {
        FileUtil.createParentDirs((File)this.myFile);
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));){
            output.writeBoolean(state != null);
            if (state != null) {
                output.writeInt(state.myProGuardConfigFiles.size());
                for (Map.Entry entry : state.myProGuardConfigFiles.entrySet()) {
                    String path = (String)entry.getKey();
                    Long timestamp = (Long)entry.getValue();
                    output.writeUTF(path);
                    output.writeLong(timestamp);
                }
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class MyState {
        private final Map<String, Long> myProGuardConfigFiles;

        public MyState(@NotNull File[] proGuardCfgFiles) {
            this.myProGuardConfigFiles = new HashMap();
            for (File file : proGuardCfgFiles) {
                this.myProGuardConfigFiles.put(file.getPath(), FileSystemUtil.lastModified((File)file));
            }
        }

        private MyState(@NotNull Map<String, Long> proGuardConfigFiles) {
            this.myProGuardConfigFiles = proGuardConfigFiles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyState state = (MyState)o;
            return this.myProGuardConfigFiles.equals(state.myProGuardConfigFiles);
        }

        public int hashCode() {
            return this.myProGuardConfigFiles.hashCode();
        }
    }
}

