/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.repository.Revision;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

public class AndroidPlatform {
    private final JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> mySdk;
    private final IAndroidTarget myTarget;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private final AndroidSdkHandler mySdkHandler;

    public AndroidPlatform(@NotNull JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, @NotNull IAndroidTarget target, @NotNull AndroidSdkHandler sdkHandler) {
        this.mySdk = sdk;
        this.myTarget = target;
        String homePath = sdk.getHomePath();
        Revision rev = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"platform-tools");
        this.myPlatformToolsRevision = rev == null ? -1 : rev.getMajor();
        rev = AndroidCommonUtils.parsePackageRevision((String)homePath, (String)"tools");
        this.mySdkToolsRevision = rev == null ? -1 : rev.getMajor();
        this.mySdkHandler = sdkHandler;
    }

    @NotNull
    public JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getSdk() {
        return this.mySdk;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return this.myTarget.getVersion().getApiLevel() <= 15;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        return this.mySdkHandler;
    }
}

