/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseUsageTracker;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseUiUtils {
    public static final String TOS_ENGLISH_LANGUAGE_TAG = "en-US";
    public static final String FIREBASE_NOTIFICATION_TITLE = FirebaseBundle.message("firebase.service.notification.title", new Object[0]);
    public static final String FIREBASE_CONFIG_JSON_FILE_NAME = "google-services.json";

    public static void showWarningBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidGradleNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.WARNING);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showTrackedErrorBalloon(@NotNull Project project, @Nullable Throwable throwable, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
        FirebaseUsageTracker.trackEvent("errorMessagePresented", messageKey, 1);
        String message = FirebaseBundle.message(messageKey, messageArguments);
        AndroidGradleNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void logSilentError(@NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey) {
        FirebaseUsageTracker.trackEvent("errorMessageSuppressed", messageKey, 1);
    }

    public static void showErrorBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidGradleNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showInfoBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidGradleNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.INFORMATION);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseUiUtils.class);
    }

    public static void checkGradleState(@NotNull Module androidModule) throws GradleStateException {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get((Module)androidModule);
        if (androidGradleModel == null) {
            throw new GradleStateException("Android Gradle Model not found.");
        }
        if (androidGradleModel.getSyncIssues() != null && androidGradleModel.getSyncIssues().size() > 0) {
            throw new GradleStateException("Android Gradle sync issues are not fully resolved");
        }
        if (GradleSyncState.getInstance((Project)androidModule.getProject()).isSyncNeeded().equals((Object)ThreeState.YES)) {
            throw new GradleStateException("Gradle sync needs to be performed.");
        }
    }

    public static class GradleStateException
    extends Exception {
        GradleStateException(String message) {
            super(message);
        }
    }
}

