/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.assistant.view.UIUtils;
import com.google.services.firebase.FirebaseIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseDialog
extends DialogWrapper {
    public static final int SIDE_INSET = UIUtil.PANEL_REGULAR_INSETS.left;
    private JPanel myContentPanel = new JPanel(new BorderLayout(0, 0));

    public FirebaseDialog(@NotNull Project project) {
        super(project);
        this.myContentPanel.add((Component)new DialogHeader(), "North");
    }

    protected Border createContentPaneBorder() {
        return new EmptyBorder(new Insets(0, 0, UIUtil.PANEL_REGULAR_INSETS.bottom, 0));
    }

    @Nullable(value="Call to super may be null")
    protected JComponent createSouthPanel() {
        JComponent south = super.createSouthPanel();
        if (south != null) {
            south.setBorder(BorderFactory.createEmptyBorder(UIUtil.PANEL_REGULAR_INSETS.top, UIUtil.PANEL_REGULAR_INSETS.left, 0, UIUtil.PANEL_REGULAR_INSETS.right));
        }
        return south;
    }

    public void addContentPanel(@NotNull JComponent contentPanel) {
        this.myContentPanel.add((Component)contentPanel, "Center");
    }

    public void setOkLabel(@NotNull String okLabel) {
        Action okAction = this.getOKAction();
        okAction.putValue("Name", okLabel);
    }

    public void setCancelLabel(@NotNull String cancelLabel) {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("Name", cancelLabel);
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private static class DialogHeader
    extends JPanel {
        DialogHeader() {
            super(new BorderLayout(10, 10));
            this.setBackground(UIUtils.getBackgroundColor());
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtils.getSeparatorColor()));
            JBLabel logo = new JBLabel();
            logo.setAlignmentX(0.0f);
            logo.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            logo.setIcon(FirebaseIcons.FIREBASE_LOGO);
            this.add((Component)logo);
        }
    }
}

