/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.api.services.mobilesdk_pa.v1.model.AndroidClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.ConsoleProject;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseProject;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.services.firebase.FirebaseBundle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlineProject {
    private static final String LEGACY_PROJECT_SUFFIX = FirebaseBundle.message("mobileSdkService.displayString.legacyProjectDisplaySuffix", new Object[0]);
    private final List<String> myWarningMessages = Lists.newArrayList();
    private final boolean myRequiredFirebaseMigration;
    private final boolean myAnalyticsEnabled;
    private final boolean myUserEditable;
    @NotNull
    private HashMap<String, FirebaseClientSummary> myFirebaseClientsByAndroidPackageName = Maps.newHashMap();
    private final int myNumAndroidOAuth2Clients;
    @NotNull
    private String myDisplayName;
    @NotNull
    private DataSharingOption myProjectDataSharingOption = DataSharingOption.DATA_NOT_LOADED;
    @NotNull
    private String myProjectNumber;

    private OnlineProject(@NotNull String projectNumber, @NotNull String displayName, boolean requiredFirebaseMigration, boolean analyticsEnabled, boolean userEditable, @Nullable(value="Caller doesn't need or have client data") Collection<FirebaseClientSummary> firebaseClients) {
        this.myProjectNumber = projectNumber;
        this.myDisplayName = displayName;
        this.myRequiredFirebaseMigration = requiredFirebaseMigration;
        if (firebaseClients != null) {
            firebaseClients.forEach(firebaseClientSummary -> {
                AndroidClientSummary androidClientSummary = firebaseClientSummary.getAndroidClientSummary();
                if (androidClientSummary != null && !Strings.isNullOrEmpty((String)androidClientSummary.getPackageName())) {
                    this.myFirebaseClientsByAndroidPackageName.put(androidClientSummary.getPackageName(), (FirebaseClientSummary)firebaseClientSummary);
                }
            });
        }
        this.myNumAndroidOAuth2Clients = this.myFirebaseClientsByAndroidPackageName.values().stream().map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).map(AndroidClientSummary::getCertificateHash).filter(Objects::nonNull).mapToInt(List::size).sum();
        this.myAnalyticsEnabled = analyticsEnabled;
        this.myUserEditable = userEditable;
    }

    @NotNull
    public static OnlineProject fromFirebaseProject(@NotNull FirebaseProject firebaseProject) {
        boolean hasEditRights = OnlineProject.hasEditRights(firebaseProject);
        List clientSummary = firebaseProject.getClientSummary();
        if (clientSummary == null) {
            clientSummary = ImmutableList.of();
        }
        return new OnlineProject(firebaseProject.getProjectNumber(), firebaseProject.getDisplayName(), false, true, hasEditRights, clientSummary);
    }

    private static boolean hasEditRights(@NotNull FirebaseProject firebaseProject) {
        if (firebaseProject.getRole() == null) {
            return false;
        }
        Role role = Role.valueOf(firebaseProject.getRole());
        return role == Role.EDITOR || role == Role.OWNER;
    }

    @NotNull
    public static OnlineProject fromConsoleProject(@NotNull ConsoleProject consoleProject) {
        boolean hasAnalytics = consoleProject.getHasScion() != null ? consoleProject.getHasScion() : false;
        return new OnlineProject(consoleProject.getProjectNumber(), consoleProject.getProjectDisplayName() + " " + LEGACY_PROJECT_SUFFIX, true, hasAnalytics, true, null);
    }

    public boolean isEditable() {
        return this.myUserEditable;
    }

    @Nullable(value="When client didn't exist for specified package name")
    public FirebaseClientSummary getFirebaseClientSummary(@NotNull String packageName) {
        return this.myFirebaseClientsByAndroidPackageName.get(packageName);
    }

    @NotNull
    public String getProjectNumber() {
        return this.myProjectNumber;
    }

    public int getNumAndroidOAuth2Clients() {
        return this.myNumAndroidOAuth2Clients;
    }

    @NotNull
    public Collection<FirebaseClientSummary> getAndroidFirebaseClientSummaries() {
        return this.myFirebaseClientsByAndroidPackageName.values();
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isAnalyticsEnabled() {
        return this.myAnalyticsEnabled;
    }

    @NotNull
    public Collection<String> getWarningMessages() {
        return ImmutableList.copyOf(this.myWarningMessages);
    }

    public void addWarningMessages(@NotNull Collection<String> warningMessages) {
        this.myWarningMessages.addAll(warningMessages);
    }

    public boolean isRequiredFirebaseMigration() {
        return this.myRequiredFirebaseMigration;
    }

    public boolean shouldShowProjectDataSharingSetting() {
        this.assertDataSharingDataLoaded();
        return this.isRequiredFirebaseMigration() && this.isAnalyticsEnabled() && DataSharingOption.MANAGED_AT_PROJECT != this.myProjectDataSharingOption;
    }

    void setProjectDataSharingOption(@NotNull DataSharingOption dataSharingOption) {
        this.myProjectDataSharingOption = dataSharingOption;
    }

    public boolean isProjectDataSharingEnabled() throws IllegalStateException {
        this.assertDataSharingDataLoaded();
        return DataSharingOption.MANAGED_AT_PROJECT == this.myProjectDataSharingOption;
    }

    private void assertDataSharingDataLoaded() {
        if (DataSharingOption.DATA_NOT_LOADED == this.myProjectDataSharingOption) {
            throw new IllegalStateException("Data sharing information not loaded");
        }
    }

    public static enum Role {
        ROLE_UNKNOWN,
        OWNER,
        EDITOR,
        VIEWER;

    }

    public static enum DataSharingOption {
        UNKNOWN_SETTING,
        MANAGED_PER_APP,
        MANAGED_AT_PROJECT,
        DATA_NOT_LOADED;

    }
}

