/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.util.Maps;
import com.google.api.client.util.Sets;
import com.google.api.services.mobilesdk_pa.v1.model.FirebaseClientSummary;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidClientMap {
    private final HashMap<AndroidClient, OnlineProject> myClientToProjectMap = Maps.newHashMap();
    private final Set<AndroidClient> myUnregisteredClients = Sets.newHashSet();

    private AndroidClientMap(@NotNull Map<AndroidClient, OnlineProject> registeredClientToProjectMap, @NotNull Collection<AndroidClient> unregisteredClients) {
        if (registeredClientToProjectMap.size() > 0) {
            this.myClientToProjectMap.putAll(registeredClientToProjectMap);
        }
        if (unregisteredClients.size() > 0) {
            this.myUnregisteredClients.addAll(unregisteredClients);
        }
    }

    @NotNull
    static AndroidClientMap resolveAndroidClients(@Nullable(value="When existing projects don't exist or an existing projects mapping isn't needed.") Collection<OnlineProject> existingProjects, @NotNull Module module) {
        AndroidFacet appAndroidFacet = AndroidFacet.getInstance((Module)module);
        if (appAndroidFacet == null) {
            throw new IllegalStateException("Could not find Android Facet associated with the Android module");
        }
        HashMap registeredClientsMap = Maps.newHashMap();
        ArrayList unknownClients = Lists.newArrayList();
        HashMap onlineClientMap = Maps.newHashMap();
        if (existingProjects != null) {
            existingProjects.stream().forEach(onlineProject -> onlineProject.getAndroidFirebaseClientSummaries().stream().filter(Objects::nonNull).map(FirebaseClientSummary::getAndroidClientSummary).filter(Objects::nonNull).filter(androidClientSummary -> androidClientSummary.getCertificateHash() != null).forEach(androidClientSummary -> {
                String packageName = androidClientSummary.getPackageName();
                androidClientSummary.getCertificateHash().stream().filter(Objects::nonNull).forEach(sha1 -> {
                    AndroidClient client = AndroidClient.createClient(packageName, sha1);
                    if (client != null) {
                        AndroidClientMap.getLog().info("Client (" + client.toString() + ") registered with project " + onlineProject.getDisplayName() + "(" + onlineProject.getProjectNumber() + ")");
                        onlineClientMap.put(client, onlineProject);
                    } else {
                        AndroidClientMap.getLog().info("Ignoring package and sha1: " + packageName + ":" + sha1);
                    }
                });
            }));
        }
        Collection<AndroidClient> studioClients = AndroidClient.getAndroidClients(module, appAndroidFacet);
        for (AndroidClient studioClient : studioClients) {
            if (onlineClientMap.containsKey(studioClient)) {
                AndroidClientMap.getLog().info("Registered client: " + studioClient);
                registeredClientsMap.put(studioClient, onlineClientMap.get(studioClient));
                continue;
            }
            AndroidClientMap.getLog().info("Unregisterd client: " + studioClient);
            unknownClients.add(studioClient);
        }
        return new AndroidClientMap(registeredClientsMap, unknownClients);
    }

    private static Logger getLog() {
        return Logger.getInstance(AndroidClientMap.class);
    }

    @NotNull
    public Map<AndroidClient, OnlineProject> getClientToProjectMap() {
        return ImmutableMap.copyOf(this.myClientToProjectMap);
    }

    @NotNull
    public Set<AndroidClient> getUnregisteredClients() {
        return ImmutableSet.copyOf(this.myUnregisteredClients);
    }

    @NotNull
    public Set<OnlineProject> getMappedOnlineProjects() {
        return ImmutableSet.copyOf(this.myClientToProjectMap.values());
    }
}

