/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.EdtInvocationManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAsyncStateManager
implements AssistActionStateManager {
    protected Map<DeveloperServiceMap.DeveloperServiceList, String> myStateMessageMap = new HashMap<DeveloperServiceMap.DeveloperServiceList, String>();
    @NotNull
    private HashMap<Integer, ModuleState> myModuleStates = new HashMap();

    private static Logger getLog() {
        return Logger.getInstance(ModuleAsyncStateManager.class);
    }

    public void updateAllModuleStates(@NotNull Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!this.myModuleStates.containsKey(module.hashCode())) continue;
            this.requestModuleStatusUpdate(module);
        }
    }

    public AssistActionStateManager.ActionState getState(@NotNull DeveloperServiceMap.DeveloperServiceList services) {
        this.myStateMessageMap.remove(services);
        ModuleAsyncStateManager.getLog().debug("getState called for service id: " + services.getMetadata().getId());
        int numCompleted = 0;
        for (DeveloperService service : services) {
            Module module = service.getModule();
            if (this.myModuleStates.containsKey(module.hashCode())) {
                if (this.myModuleStates.get(module.hashCode()).isCompletable()) continue;
                ++numCompleted;
                continue;
            }
            this.requestModuleStatusUpdate(module);
        }
        if (numCompleted == 0) {
            return AssistActionStateManager.ActionState.INCOMPLETE;
        }
        if (numCompleted != services.size()) {
            this.myStateMessageMap.put(services, FirebaseBundle.message("dependencies.add.partiallyCompleted", numCompleted, services.size()));
            return AssistActionStateManager.ActionState.PARTIALLY_COMPLETE;
        }
        return AssistActionStateManager.ActionState.COMPLETE;
    }

    protected void requestModuleStatusUpdate(@NotNull Module module) {
        ModuleState currentState = this.getModuleState(module);
        currentState.startRefreshTask(module);
    }

    void updateModuleState(Module module, boolean newIsCompletableState) {
        ModuleAsyncStateManager.getLog().debug("Updating module state: " + newIsCompletableState);
        ModuleState moduleState = this.getModuleState(module);
        if (moduleState.isCompletable() != newIsCompletableState) {
            ModuleAsyncStateManager.getLog().debug("Sending refresh notification Stateful button.");
            moduleState.setCompletable(newIsCompletableState);
            MessageBus bus = module.getMessageBus();
            StatefulButtonNotifier publisher = (StatefulButtonNotifier)bus.syncPublisher(StatefulButtonNotifier.BUTTON_STATE_TOPIC);
            publisher.stateUpdated();
        } else {
            ModuleAsyncStateManager.getLog().debug("Module state did not change.");
        }
    }

    @NotNull
    private ModuleState getModuleState(Module module) {
        ModuleState moduleState = this.myModuleStates.get(module.hashCode());
        if (moduleState == null) {
            moduleState = new ModuleState(module);
            this.myModuleStates.put(module.hashCode(), moduleState);
        }
        return moduleState;
    }

    abstract boolean calculateState(@NotNull Module var1);

    abstract String getTaskDisplayName();

    private class ModuleState {
        @NotNull
        private final Object myTaskLock = new Object();
        @Nullable(value="When a task is not running")
        private WeakReference<Task.Backgroundable> myModuleUpdateTask;
        private int myNumRequestedStateUpdates;
        private boolean myIsCompletable = true;

        ModuleState(Module module) {
        }

        boolean isCompletable() {
            return this.myIsCompletable;
        }

        void setCompletable(boolean completable) {
            this.myIsCompletable = completable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void startRefreshTask(Module module) {
            Object object = this.myTaskLock;
            synchronized (object) {
                ++this.myNumRequestedStateUpdates;
                if (this.myModuleUpdateTask == null || this.myModuleUpdateTask.get() == null) {
                    this.myModuleUpdateTask = new WeakReference<Task.Backgroundable>(this.runRefreshStateTask(module));
                }
            }
        }

        @NotNull
        private Task.Backgroundable runRefreshStateTask(final Module module) {
            ModuleAsyncStateManager.getLog().debug("Performing refresh task on module: " + module.getName());
            Task.Backgroundable refreshTask = new Task.Backgroundable(module.getProject(), ModuleAsyncStateManager.this.getTaskDisplayName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        int numStateUpdates;
                        int numLoops = 0;
                        do {
                            ++numLoops;
                            Object object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                ModuleState.this.myNumRequestedStateUpdates = 0;
                            }
                            ModuleAsyncStateManager.getLog().debug("Running calculateState");
                            ModuleAsyncStateManager.this.updateModuleState(module, ModuleAsyncStateManager.this.calculateState(module));
                            object = ModuleState.this.myTaskLock;
                            synchronized (object) {
                                numStateUpdates = ModuleState.this.myNumRequestedStateUpdates;
                            }
                        } while (numStateUpdates > 0 && numLoops < 5);
                    }
                    finally {
                        Object object = ModuleState.this.myTaskLock;
                        synchronized (object) {
                            ModuleState.this.myModuleUpdateTask = null;
                        }
                    }
                }
            };
            EdtInvocationManager.getInstance().invokeLater(() -> ProgressManager.getInstance().run((Task)refreshTask));
            return refreshTask;
        }
    }
}

