/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyStateManager
implements AssistActionStateManager {
    private Map<DeveloperServiceMap.DeveloperServiceList, AssistActionStateManager.ActionState> myStateMap = new HashMap<DeveloperServiceMap.DeveloperServiceList, AssistActionStateManager.ActionState>();
    private Map<DeveloperServiceMap.DeveloperServiceList, String> myStateMessageMap = new HashMap<DeveloperServiceMap.DeveloperServiceList, String>();
    private Set<Project> myRegisteredProjects = new HashSet<Project>();

    private static Logger getLog() {
        return Logger.getInstance(DependencyStateManager.class);
    }

    private AssistActionStateManager.ActionState getDependencyState(@NotNull DeveloperServiceMap.DeveloperServiceList services) {
        this.myStateMessageMap.remove(services);
        DeveloperServiceMetadata metadata = services.getMetadata();
        GradleBuildModel projectGradleBuildModel = GradleBuildModel.get((Project)services.getProject());
        DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
        for (String classpathEntry : metadata.getClasspathEntries()) {
            if (!dependencies.containsArtifact("classpath", ArtifactDependencySpec.create((String)classpathEntry))) {
                DependencyStateManager.getLog().info("did not find classpath: " + classpathEntry);
                return AssistActionStateManager.ActionState.INCOMPLETE;
            }
            DependencyStateManager.getLog().debug("found classpath: " + classpathEntry);
        }
        int numCompleted = 0;
        for (DeveloperService service : services) {
            GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)service.getModule());
            List plugins = gradleBuildModel.appliedPlugins();
            boolean missingPlugin = false;
            for (String plugin : metadata.getPlugins()) {
                if (!plugins.contains(plugin)) {
                    DependencyStateManager.getLog().info("did not find plugin: " + plugin);
                    missingPlugin = true;
                    continue;
                }
                DependencyStateManager.getLog().debug("found plugin: " + plugin);
            }
            if (missingPlugin || !service.isInstalled()) continue;
            ++numCompleted;
        }
        if (numCompleted == 0) {
            return AssistActionStateManager.ActionState.INCOMPLETE;
        }
        if (numCompleted != services.size()) {
            this.myStateMessageMap.put(services, FirebaseBundle.message("dependencies.add.partiallyCompleted", numCompleted, services.size()));
            return AssistActionStateManager.ActionState.PARTIALLY_COMPLETE;
        }
        return AssistActionStateManager.ActionState.COMPLETE;
    }

    @NotNull
    public String getId() {
        return "firebase.add_dependencies";
    }

    public void init(@NotNull DeveloperServiceMap.DeveloperServiceList services) {
        this.myStateMap.put(services, this.getDependencyState(services));
        Project project = services.getProject();
        if (this.myRegisteredProjects.contains(project)) {
            return;
        }
        this.myRegisteredProjects.add(project);
        GradleSyncState.subscribe((Project)project, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                DependencyStateManager.this.refreshDependencyState();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                DependencyStateManager.this.refreshDependencyState();
            }
        });
    }

    public AssistActionStateManager.ActionState getState(@NotNull DeveloperServiceMap.DeveloperServiceList services) {
        if (!this.myStateMap.containsKey(services)) {
            return AssistActionStateManager.ActionState.INCOMPLETE;
        }
        return this.myStateMap.get(services);
    }

    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull DeveloperServiceMap.DeveloperServiceList services, @Nullable String successMessage) {
        String message = null;
        message = this.myStateMessageMap.containsKey(services) ? this.myStateMessageMap.get(services) : successMessage;
        return new StatefulButtonMessage(message, this.getState(services));
    }

    private void refreshDependencyState() {
        DependencyStateManager.getLog().info("Refreshing dependency state");
        boolean stateChanged = false;
        HashSet<Module> sampleModules = new HashSet<Module>();
        for (Map.Entry<DeveloperServiceMap.DeveloperServiceList, AssistActionStateManager.ActionState> entry : this.myStateMap.entrySet()) {
            String newMessage;
            AssistActionStateManager.ActionState state = entry.getValue();
            DeveloperServiceMap.DeveloperServiceList services = entry.getKey();
            String oldMessage = this.myStateMessageMap.get(services);
            AssistActionStateManager.ActionState newValue = this.getDependencyState(services);
            if (!state.equals((Object)newValue)) {
                entry.setValue(newValue);
                stateChanged = true;
            }
            if ((newMessage = this.myStateMessageMap.get(services)) != null && !newMessage.equals(oldMessage)) {
                stateChanged = true;
            }
            if (!stateChanged) continue;
            sampleModules.add(((DeveloperService)services.get(0)).getModule());
        }
        if (!stateChanged) {
            return;
        }
        if (sampleModules.size() > 0) {
            for (Module module : sampleModules) {
                MessageBus bus = module.getMessageBus();
                StatefulButtonNotifier publisher = (StatefulButtonNotifier)bus.syncPublisher(StatefulButtonNotifier.BUTTON_STATE_TOPIC);
                publisher.stateUpdated();
            }
        }
    }
}

