/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.google.api.client.util.Lists;
import com.google.services.firebase.FirebaseBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyDialog
extends DialogWrapper {
    private ProjectChangesPanel myContentPanel;
    private Module mySelectedModule;

    DependencyDialog(@NotNull DeveloperServiceMap.DeveloperServiceList services) {
        super(services.getProject(), false);
        DeveloperServiceMetadata metadata = services.getMetadata();
        if (services.getModules().size() == 1) {
            this.mySelectedModule = (Module)services.getModules().iterator().next();
        } else {
            this.setOKActionEnabled(false);
        }
        this.myContentPanel = new ProjectChangesPanel(services);
        this.init();
        this.setTitle("Add " + metadata.getName());
        Action okAction = this.getOKAction();
        okAction.putValue("Name", "Accept Changes");
    }

    @NotNull
    public static ComboBox createModuleComboBox(Set<Module> modules) {
        ComboBox comboBox = new ComboBox(modules.toArray());
        comboBox.setBackground(UIUtils.getBackgroundColor());
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Module module = (Module)value;
                if (module != null) {
                    this.setText(module.getName());
                }
            }
        });
        comboBox.setBackground(UIUtils.getBackgroundColor());
        comboBox.setSelectedIndex(-1);
        return comboBox;
    }

    @NotNull
    public Module getModule() {
        return this.mySelectedModule;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public class ProjectChangesPanel
    extends JPanel {
        private ComboBox myModuleBox;

        public ProjectChangesPanel(DeveloperServiceMap.DeveloperServiceList services) {
            super(new BorderLayout());
            if (DependencyDialog.this.mySelectedModule == null) {
                JPanel moduleWrapper = new JPanel(new FlowLayout(0, 0, 5));
                moduleWrapper.setOpaque(false);
                JBLabel moduleLabel = new JBLabel(FirebaseBundle.message("dependencies.add.selectModule.label", new Object[0]));
                moduleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                moduleWrapper.add((Component)moduleLabel);
                this.myModuleBox = DependencyDialog.createModuleComboBox(services.getModules());
                moduleWrapper.add((Component)this.myModuleBox);
                this.add((Component)moduleWrapper, "North");
                this.myModuleBox.addActionListener(e -> this.selectModule(e));
            }
            DeveloperServiceMetadata metadata = services.getMetadata();
            String serviceName = metadata.getName();
            List classpathEntriesToAdd = metadata.getClasspathEntries();
            ArrayList classpathEntriesToRemove = Lists.newArrayList();
            GradleBuildModel projectGradleBuildModel = GradleBuildModel.get((Project)services.getProject());
            DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
            for (String classpathEntry : classpathEntriesToAdd) {
                if (!dependencies.containsArtifact("classpath", ArtifactDependencySpec.create((String)classpathEntry))) continue;
                this.getLog().warn("Found already installed classpath entry: " + classpathEntry);
                classpathEntriesToRemove.add(classpathEntry);
            }
            classpathEntriesToAdd.removeAll(classpathEntriesToRemove);
            List pluginsToApply = metadata.getPlugins();
            JLabel summary = new JLabel();
            summary.setOpaque(false);
            summary.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            summary.setText("Adding " + serviceName + " will make the following changes to your project.");
            this.add((Component)summary, "Center");
            StringBuilder detailsBuilder = new StringBuilder();
            String detailsCss = ".dependency { color: green; font-weight: bold; font-family: monospace; }\nbody {padding: 10px; }";
            String indent_1 = "    ";
            String indent_2 = "        ";
            if (classpathEntriesToAdd.size() > 0) {
                detailsBuilder.append("<pre><b>build.gradle (project-level)</b>\n\n").append(indent_1 + "Add Firebase Gradle buildscript dependency\n");
                for (String classpathEntry : classpathEntriesToAdd) {
                    detailsBuilder.append(indent_2 + "classpath <font class=\"dependency\">'" + classpathEntry + "'</font>\n");
                }
                detailsBuilder.append("</pre>");
                detailsBuilder.append("<div style=\"height: 1px; font-size: 0; background: #cccccc;\"></div><br>");
            }
            detailsBuilder.append("<pre><b>app/build.gradle</b>\n\n");
            if (pluginsToApply.size() > 0) {
                detailsBuilder.append(indent_1 + "Add Firebase plugin for Gradle\n");
                for (Object plugin : pluginsToApply) {
                    detailsBuilder.append(indent_2 + "apply plugin: <font class=\"dependency\">'" + (String)plugin + "'</font>\n");
                }
                detailsBuilder.append("\n");
            }
            boolean hasAnalytics = false;
            detailsBuilder.append(indent_1 + "<b>build.gradle</b> will include these new dependencies:\n");
            for (String dependency : metadata.getDependencies()) {
                detailsBuilder.append(indent_2 + "compile <font class=\"dependency\">'" + dependency + "'</font>\n");
                hasAnalytics |= dependency.contains("firebase-core");
            }
            if (!hasAnalytics) {
                detailsBuilder.append("\n" + indent_2 + "This will also enable the firebase-core library");
                detailsBuilder.append("\n" + indent_2 + "including Firebase Analytics. <a href=\"https://firebase.google.com/support/studio-analytics\">Learn more</a>");
            }
            detailsBuilder.append("</pre>");
            JTextPane details = new JTextPane();
            UIUtils.setHtml((JEditorPane)details, (String)detailsBuilder.toString(), (String)detailsCss);
            details.setBackground(UIUtils.getBackgroundColor());
            details.setMargin(new Insets(10, 10, 10, 10));
            details.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtils.getSeparatorColor()));
            this.add((Component)details, "South");
        }

        void selectModule(ActionEvent e) {
            DependencyDialog.this.mySelectedModule = (Module)this.myModuleBox.getSelectedItem();
            DependencyDialog.this.setOKActionEnabled(true);
        }

        private Logger getLog() {
            return Logger.getInstance(ProjectChangesPanel.class);
        }
    }
}

