/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.google.services.firebase.DependencyDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDependencyAction
implements AssistActionHandler {
    protected static final String ACTION_KEY = "firebase.add_dependencies";

    private static Logger getLog() {
        return Logger.getInstance(AssistActionHandler.class);
    }

    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    public void handleAction(@Nullable String actionArgument, @NotNull DeveloperServiceMap.DeveloperServiceList services) {
        DependencyDialog dependencyDialog = new DependencyDialog(services);
        dependencyDialog.pack();
        if (!dependencyDialog.showAndGet()) {
            return;
        }
        Module module = dependencyDialog.getModule();
        if (module == null) {
            AddDependencyAction.getLog().error("No user selected module found to add dependencies to.");
            return;
        }
        DeveloperService service = services.get(module);
        if (service == null) {
            AddDependencyAction.getLog().error("No DeveloperService found for module '" + module.getName() + "'.");
            return;
        }
        AddDependencyAction.getLog().info("Installing " + service.getMetadata().getName() + " dependencies for module " + module.getName());
        service.install();
        GradleProjectImporter importer = GradleProjectImporter.getInstance();
        importer.requestProjectSync(services.getProject(), new GradleSyncListener(){

            public void syncStarted(@NotNull Project project) {
            }

            public void syncSucceeded(@NotNull Project project) {
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
            }

            public void syncSkipped(@NotNull Project project) {
            }
        });
        if (!service.isInstalled()) {
            AddDependencyAction.getLog().error("Attempted to add dependencies and no errors occurred but dependencies were not found.");
        }
    }
}

