/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.immutable.ImmutableClassDef;
import org.jf.util.ImmutableUtils;

public class ImmutableDexFile
implements DexFile {
    @Nonnull
    protected final ImmutableSet<? extends ImmutableClassDef> classes;

    public ImmutableDexFile(@Nullable Collection<? extends ClassDef> classes) {
        this.classes = ImmutableClassDef.immutableSetOf(classes);
    }

    public ImmutableDexFile(@Nullable ImmutableSet<? extends ImmutableClassDef> classes) {
        this.classes = ImmutableUtils.nullToEmptySet(classes);
    }

    public static ImmutableDexFile of(DexFile dexFile) {
        if (dexFile instanceof ImmutableDexFile) {
            return (ImmutableDexFile)dexFile;
        }
        return new ImmutableDexFile(dexFile.getClasses());
    }

    @Nonnull
    public ImmutableSet<? extends ImmutableClassDef> getClasses() {
        return this.classes;
    }
}

