/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.Semaphore;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.lib.cvsclient.ICvsCommandStopper;

public class ReadThread
implements Runnable {
    public static final Collection<ReadThread> READ_THREADS = Collections.synchronizedCollection(new ArrayList());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.javacvsImpl.io.ReadThread");
    private static final int INITIAL_BUFFER_SIZE = 131072;
    private static final int TIMEOUT = 3000;
    private static final int END_OF_STREAM = -1;
    private boolean myAtEndOfStream = false;
    private final ICvsCommandStopper myCvsCommandStopper;
    private final byte[] myBuffer = new byte[131072];
    private final byte[] myReadBuffer = new byte[131072];
    private int myFirstIndex = 0;
    private int myLastIndex = 0;
    private IOException myException;
    private final InputStream myInputStream;
    private final Semaphore myStarted = new Semaphore();
    private boolean myIsClosed = false;

    public ReadThread(InputStream inputStream, ICvsCommandStopper cvsCommandStopper) {
        this.myInputStream = inputStream;
        this.myCvsCommandStopper = cvsCommandStopper;
        READ_THREADS.add(this);
    }

    public void prepareForWait() {
        this.myStarted.down();
    }

    public void waitForStart() {
        this.myStarted.waitFor();
    }

    public String toString() {
        return super.toString() + ", atEnd: " + this.myAtEndOfStream + ", firstIndex: " + this.myFirstIndex + ", lastIndex: " + this.myLastIndex + ", exception: " + this.myException + ", closed: " + this.myIsClosed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.info("Starting CvsReadThread " + this);
            }
            while (true) {
                try {
                    this.waitForRead();
                    if (this.myAtEndOfStream || this.myException != null) {
                        this.executionCompleted();
                        return;
                    }
                }
                catch (IOException e) {
                    this.detectExceptionAndNotify(e);
                    return;
                }
                catch (Throwable t) {
                    this.detectExceptionAndNotify(new IOException(t.getLocalizedMessage()));
                    return;
                }
                int result = this.myInputStream.read(this.myReadBuffer);
                if (result > 0) {
                    this.writeAndNotify(result);
                    continue;
                }
                if (result == -1) break;
            }
            this.detectEndAndNotify();
            return;
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
    }

    public synchronized int read() throws IOException {
        int result = this.waitForAvailableBytes();
        if (result == -1) {
            return -1;
        }
        return this.internalRead();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result = this.waitForAvailableBytes();
        if (result == -1) {
            return -1;
        }
        return this.internalRead(b, off, len);
    }

    public synchronized long skip(long n) throws IOException {
        int result = this.waitForAvailableBytes();
        if (result == -1) {
            return -1L;
        }
        return this.internalSkip(n);
    }

    public synchronized int available() throws IOException {
        if (this.size() > 0) {
            return this.size();
        }
        if (this.myAtEndOfStream) {
            return -1;
        }
        return this.myInputStream.available();
    }

    private int waitForAvailableBytes() throws IOException {
        while (this.size() == 0 && !this.myAtEndOfStream) {
            try {
                this.notify();
                this.wait(3000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            if (this.size() != 0 || this.myAtEndOfStream || !this.myCvsCommandStopper.isAborted()) continue;
            throw new ProcessCanceledException();
        }
        if (this.myException != null) {
            throw this.myException;
        }
        if (this.myAtEndOfStream && this.size() == 0) {
            return -1;
        }
        return -2;
    }

    private synchronized void detectExceptionAndNotify(IOException e) {
        LOG.info((Throwable)e);
        this.myException = e;
        this.executionCompleted();
        this.notify();
    }

    private synchronized void detectEndAndNotify() {
        if (!this.myAtEndOfStream) {
            this.myAtEndOfStream = true;
            this.notify();
        }
        this.executionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeAndNotify(int result) {
        ReadThread readThread = this;
        synchronized (readThread) {
            if (this.size() == 0) {
                this.myFirstIndex = 0;
                this.myLastIndex = 0;
            }
            System.arraycopy(this.myReadBuffer, 0, this.myBuffer, this.myLastIndex, result);
            this.myLastIndex += result;
        }
        this.notify();
    }

    private synchronized void waitForRead() throws InterruptedException {
        this.myStarted.up();
        if (this.myAtEndOfStream || this.myException != null) {
            return;
        }
        this.wait();
    }

    private void executionCompleted() {
        READ_THREADS.remove(this);
        if (LOG.isDebugEnabled()) {
            LOG.info("Stopping CvsReadThread " + this);
        }
    }

    private int size() {
        return this.myLastIndex - this.myFirstIndex;
    }

    public synchronized void close() throws IOException {
        this.myIsClosed = true;
        if (this.myAtEndOfStream) {
            return;
        }
        this.myAtEndOfStream = true;
        this.notify();
    }

    private synchronized int internalRead() {
        try {
            char c = (char)this.myBuffer[this.myFirstIndex++];
            return c;
        }
        finally {
            if (this.myFirstIndex > this.myLastIndex) {
                LOG.assertTrue(false);
            }
        }
    }

    private synchronized int internalRead(byte[] b, int off, int len) {
        int result = Math.min(len, this.size());
        System.arraycopy(this.myBuffer, this.myFirstIndex, b, off, result);
        this.myFirstIndex += result;
        return result;
    }

    private long internalSkip(long n) {
        long result = Math.min(n, (long)this.size());
        this.myFirstIndex = (int)((long)this.myFirstIndex + result);
        return result;
    }
}

