/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiElement;
import com.android.tools.lint.psi.EcjPsiJavaFile;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;

abstract class EcjPsiSourceElement
extends EcjPsiElement
implements PsiElement,
NavigationItem,
Navigatable {
    protected ASTNode mNativeNode;
    protected PsiFile mFile;
    protected EcjPsiSourceElement mParent;
    protected TextRange mRange;
    protected EcjPsiSourceElement mFirstChild;
    protected EcjPsiSourceElement mLastChild;
    protected EcjPsiSourceElement mNextSibling;
    protected EcjPsiSourceElement mPrevSibling;

    protected EcjPsiSourceElement(EcjPsiManager manager, ASTNode ecjNode) {
        super(manager);
        if (ecjNode != null) {
            this.mNativeNode = ecjNode;
            this.setRange(ecjNode.sourceStart, ecjNode.sourceEnd + 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        TextRange range = this.getTextRange();
        if (range != null) {
            sb.append(range.toString());
            String text = this.getText();
            if (text != null) {
                int SNIPPET_LENGTH = 40;
                sb.append(':');
                int length = text.length();
                sb.append('\"');
                text = text.substring(0, Math.min(40, length)).replace("\n", "\\n");
                sb.append(text);
                if (length > 40) {
                    sb.append('\u2026');
                }
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    public abstract void accept(PsiElementVisitor var1);

    public final void acceptChildren(PsiElementVisitor visitor) {
        EcjPsiSourceElement child = this.mFirstChild;
        while (child != null) {
            child.accept(visitor);
            child = child.mNextSibling;
        }
    }

    public Object getNativeNode() {
        return this.mNativeNode;
    }

    public void setNativeNode(ASTNode nativeNode) {
        this.mNativeNode = nativeNode;
    }

    protected void adoptChild(EcjPsiSourceElement child) {
        assert (child.getParent() == null);
        child.setParent(this);
        if (this.mFirstChild == null) {
            this.mFirstChild = child;
            this.mLastChild = child;
        } else {
            this.mLastChild.mNextSibling = child;
            child.mPrevSibling = this.mLastChild;
            this.mLastChild = child;
        }
    }

    protected void setRange(int start, int end) {
        this.mRange = new TextRange(start, end);
    }

    void setParent(EcjPsiSourceElement parent) {
        this.mParent = parent;
    }

    void setRange(TextRange range) {
        this.mRange = range;
    }

    @Override
    public PsiElement[] getChildren() {
        if (this.mFirstChild == null) {
            return new PsiElement[0];
        }
        if (this.mFirstChild.mNextSibling == null) {
            return new PsiElement[]{this.mFirstChild};
        }
        EcjPsiSourceElement curr = this.mFirstChild;
        int count = 0;
        while (curr != null) {
            curr = curr.mNextSibling;
            ++count;
        }
        PsiElement[] children = new PsiElement[count];
        curr = this.mFirstChild;
        int index = 0;
        while (curr != null) {
            children[index++] = curr;
            curr = curr.mNextSibling;
        }
        assert (index == count);
        return children;
    }

    @Override
    public EcjPsiSourceElement getParent() {
        return this.mParent;
    }

    @Override
    public PsiElement getFirstChild() {
        return this.mFirstChild;
    }

    @Override
    public PsiElement getLastChild() {
        return this.mLastChild;
    }

    @Override
    public PsiElement getNextSibling() {
        return this.mNextSibling;
    }

    @Override
    public PsiElement getPrevSibling() {
        return this.mPrevSibling;
    }

    @Override
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        if (this.mFile != null) {
            return this.mFile;
        }
        if (this.mParent != null) {
            this.mFile = this.mParent.getContainingFile();
            return this.mFile;
        }
        return null;
    }

    @Override
    public TextRange getTextRange() {
        if (this.mRange == null) {
            if (this.mFirstChild != null) {
                this.setRange(this.mFirstChild.getTextRange().getStartOffset(), this.getLastChild().getTextRange().getEndOffset());
            } else {
                int startOffset = 0;
                if (this.mPrevSibling != null && this.mPrevSibling.getTextRange() != null) {
                    startOffset = this.mPrevSibling.getTextRange().getEndOffset();
                } else if (this.mParent != null && this.mParent.getTextRange() != null) {
                    startOffset = this.mParent.getTextRange().getStartOffset();
                }
                int endOffset = startOffset;
                this.mRange = new TextRange(startOffset, endOffset);
            }
        }
        return this.mRange;
    }

    @Override
    public int getStartOffsetInParent() {
        int startOffset = this.getTextRange().getStartOffset();
        return this.mParent != null ? startOffset - this.mParent.getTextRange().getStartOffset() : startOffset;
    }

    @Override
    public int getTextLength() {
        return this.getTextRange().getEndOffset() - this.getTextRange().getStartOffset();
    }

    @Override
    public int getTextOffset() {
        return this.getTextRange().getStartOffset();
    }

    @Override
    public String getText() {
        EcjPsiJavaFile file = this instanceof EcjPsiJavaFile ? (EcjPsiJavaFile)this : (EcjPsiJavaFile)this.getContainingFile();
        if (file != null) {
            String text;
            TextRange range = this.getTextRange();
            if (range != null && (text = file.getText()) != null) {
                return text.substring(range.getStartOffset(), range.getEndOffset());
            }
            return super.toString();
        }
        return "<text not available>";
    }

    @Override
    public char[] textToCharArray() {
        return this.getText().toCharArray();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public boolean textMatches(CharSequence charSequence) {
        return this.getText().equals(charSequence.toString());
    }

    @Override
    public boolean textMatches(PsiElement psiElement) {
        return this.getText().equals(psiElement.getText());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) != -1;
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    public PsiReference[] getReferences() {
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getContext() {
        return this.mParent;
    }

    public String getName() {
        throw new UnimplementedLintPsiApiException();
    }
}

