/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiImport;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.EcjPsiStaticImport;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import java.util.ArrayList;
import java.util.List;

class EcjPsiImportList
extends EcjPsiSourceElement
implements PsiImportList {
    private List<EcjPsiImport> mImports;

    EcjPsiImportList(EcjPsiManager manager) {
        super(manager, null);
    }

    void setImports(List<EcjPsiImport> imports) {
        this.mImports = imports;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList((PsiImportList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiImportStatement[] getImportStatements() {
        return this.mImports.toArray(new PsiImportStatement[0]);
    }

    public PsiImportStaticStatement[] getImportStaticStatements() {
        ArrayList result = Lists.newArrayList();
        for (EcjPsiImport statement : this.mImports) {
            if (!(statement instanceof EcjPsiStaticImport)) continue;
            result.add((EcjPsiStaticImport)statement);
        }
        return result.toArray(new PsiImportStaticStatement[0]);
    }

    public PsiImportStatementBase[] getAllImportStatements() {
        return (PsiImportStatementBase[])this.mImports.toArray(new PsiImportStatement[0]);
    }

    public PsiImportStatement findSingleClassImportStatement(String s) {
        for (PsiImportStatement psiImportStatement : this.mImports) {
            if (!s.equals(psiImportStatement.getQualifiedName())) continue;
            return psiImportStatement;
        }
        return null;
    }

    public PsiImportStatement findOnDemandImportStatement(String packageName) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiImportStatementBase findSingleImportStatement(String s) {
        for (PsiImportStatement psiImportStatement : this.mImports) {
            if (!s.equals(psiImportStatement.getQualifiedName())) continue;
            return psiImportStatement;
        }
        return null;
    }
}

