/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;

class EcjPsiImport
extends EcjPsiSourceElement
implements PsiImportStatement {
    private final String mQualifiedName;
    private final boolean mOnDemand;
    private PsiJavaCodeReferenceElement mReference;

    EcjPsiImport(EcjPsiManager manager, ImportReference importReference, String qualifiedName, boolean onDemand) {
        super(manager, null);
        this.mNativeNode = importReference;
        this.setRange(importReference.declarationSourceStart, importReference.declarationSourceEnd + 1);
        this.mQualifiedName = qualifiedName;
        this.mOnDemand = onDemand;
    }

    void setReference(PsiJavaCodeReferenceElement reference) {
        this.mReference = reference;
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.mQualifiedName;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStatement((PsiImportStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getQualifiedName() {
        return this.mQualifiedName;
    }

    public boolean isOnDemand() {
        return this.mOnDemand;
    }

    public boolean isForeignFileImport() {
        return false;
    }

    public PsiJavaCodeReferenceElement getImportReference() {
        return this.mReference;
    }

    public PsiElement resolve() {
        return this.mManager.findElement(this.mNativeNode);
    }
}

