/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.InlineOnly;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.LinesSequence;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u0017\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u000e*\u00020\u0002\u001a\u0017\u0010\u0016\u001a\u00020\u000e*\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0087\b\u001a\r\u0010\u0019\u001a\u00020\u001a*\u00020\u000eH\u0087\b\u001a6\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e\"\u0004\b\u0001\u0010\u001c*\u0002H\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001c0\rH\u0087\b\u00a2\u0006\u0002\u0010 \u001a2\u0010!\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d*\u00020\u00022\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0010\u0012\u0004\u0012\u0002H\u001d0\rH\u0086\b\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"buffered", "Ljava/io/BufferedReader;", "Ljava/io/Reader;", "bufferSize", "", "Ljava/io/BufferedWriter;", "Ljava/io/Writer;", "copyTo", "", "out", "forEachLine", "", "action", "Lkotlin/Function1;", "", "lineSequence", "Lkotlin/sequences/Sequence;", "readBytes", "", "Ljava/net/URL;", "readLines", "", "readText", "charset", "Ljava/nio/charset/Charset;", "reader", "Ljava/io/StringReader;", "use", "R", "T", "Ljava/io/Closeable;", "block", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useLines", "(Ljava/io/Reader;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-stdlib"})
@JvmName(name="TextStreamsKt")
public final class TextStreamsKt {
    @InlineOnly
    private static final BufferedReader buffered(Reader $receiver, int bufferSize) {
        return $receiver instanceof BufferedReader ? (BufferedReader)$receiver : new BufferedReader($receiver, bufferSize);
    }

    @InlineOnly
    static /* bridge */ /* synthetic */ BufferedReader buffered$default(Reader reader, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if ((n2 & 1) != 0) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    @InlineOnly
    private static final BufferedWriter buffered(Writer $receiver, int bufferSize) {
        return $receiver instanceof BufferedWriter ? (BufferedWriter)$receiver : new BufferedWriter($receiver, bufferSize);
    }

    @InlineOnly
    static /* bridge */ /* synthetic */ BufferedWriter buffered$default(Writer writer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if ((n2 & 1) != 0) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void forEachLine(Reader $receiver, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(action, "action");
        Reader $receiver$iv = $receiver;
        Reader reader = $receiver$iv;
        int n = 0;
        boolean bl = true;
        Object var6_9 = null;
        if (var6_9 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Closeable $receiver$iv$iv = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        boolean closed$iv$iv = false;
        try {
            void $receiver$iv2;
            Sequence<String> it;
            Object it$iv = (BufferedReader)$receiver$iv$iv;
            Sequence<String> sequence = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            Function1<? super String, Unit> function1 = action;
            for (Object element$iv : $receiver$iv2) {
                void action$iv;
                action$iv.invoke(element$iv);
            }
            it$iv = Unit.INSTANCE;
        }
        catch (Exception e$iv$iv) {
            closed$iv$iv = true;
            try {
                $receiver$iv$iv.close();
            }
            catch (Exception closeException$iv$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv$iv;
        }
        finally {
            if (!closed$iv$iv) {
                $receiver$iv$iv.close();
            }
        }
    }

    @NotNull
    public static final List<String> readLines(Reader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList<String> result = CollectionsKt.arrayListOf(new String[0]);
        TextStreamsKt.forEachLine($receiver, (Function1<? super String, Unit>)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList $result;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.$result.add(it);
            }
            {
                this.$result = arrayList;
                super(1);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T useLines(Reader $receiver, @NotNull Function1<? super Sequence<String>, ? extends T> block) {
        BufferedReader it;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Reader reader = $receiver;
        int n = 0;
        boolean bl = true;
        Object var6_8 = null;
        if (var6_8 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Closeable $receiver$iv = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        boolean closed$iv = false;
        try {
            it = (BufferedReader)$receiver$iv;
            it = block.invoke(TextStreamsKt.lineSequence(it));
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (!closed$iv) {
                $receiver$iv.close();
            }
            InlineMarker.finallyEnd(1);
        }
        return (T)it;
    }

    @InlineOnly
    private static final StringReader reader(String $receiver) {
        return new StringReader($receiver);
    }

    @NotNull
    public static final Sequence<String> lineSequence(BufferedReader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SequencesKt.constrainOnce(new LinesSequence($receiver));
    }

    @NotNull
    public static final String readText(Reader $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        StringWriter buffer = new StringWriter();
        TextStreamsKt.copyTo$default($receiver, buffer, 0, 2, null);
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "buffer.toString()");
        return string;
    }

    public static final long copyTo(Reader $receiver, @NotNull Writer out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $receiver.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $receiver.read(buffer);
        }
        return charsCopied;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
        }
        if ((n2 & 2) != 0) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        return TextStreamsKt.copyTo(reader, writer, n);
    }

    @InlineOnly
    private static final String readText(URL $receiver, Charset charset) {
        byte[] $receiver$iv = TextStreamsKt.readBytes($receiver);
        return new String($receiver$iv, charset);
    }

    @InlineOnly
    static /* bridge */ /* synthetic */ String readText$default(URL uRL, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readText");
        }
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        byte[] $receiver$iv = TextStreamsKt.readBytes(uRL);
        return new String($receiver$iv, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(URL $receiver) {
        Object it;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Closeable $receiver$iv = $receiver.openStream();
        boolean closed$iv = false;
        try {
            it = (InputStream)$receiver$iv;
            it = ByteStreamsKt.readBytes$default((InputStream)it, 0, 1, null);
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return (byte[])it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InlineOnly
    private static final <T extends Closeable, R> R use(T $receiver, Function1<? super T, ? extends R> block) {
        boolean closed = false;
        try {
            R r = block.invoke($receiver);
            return r;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            InlineMarker.finallyStart(1);
            if (!closed) {
                $receiver.close();
            }
            InlineMarker.finallyEnd(1);
        }
    }
}

