/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.util.StringsPool;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class Instrumenter
extends ClassVisitor {
    protected final ProjectData myProjectData;
    protected final ClassVisitor myClassVisitor;
    private final String myClassName;
    private final boolean myShouldCalculateSource;
    protected TIntObjectHashMap myLines = new TIntObjectHashMap(4, 0.99f);
    protected int myMaxLineNumber;
    protected ClassData myClassData;
    protected boolean myProcess;
    private boolean myEnum;

    public Instrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(327680, classVisitor);
        this.myProjectData = projectData;
        this.myClassVisitor = classVisitor;
        this.myClassName = className;
        this.myShouldCalculateSource = shouldCalculateSource;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
        this.myProcess = (access & 0x200) == 0;
        this.myClassData = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.myClassName));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if ((access & 0x40) != 0) {
            return mv;
        }
        if ((access & 0x400) != 0) {
            return mv;
        }
        if (this.myEnum && Instrumenter.isDefaultEnumMethod(name, desc, signature, this.myClassName)) {
            return mv;
        }
        this.myProcess = true;
        return this.createMethodLineEnumerator(mv, name, desc, access, signature, exceptions);
    }

    private static boolean isDefaultEnumMethod(String name, String desc, String signature, String className) {
        return name.equals("values") && desc.equals("()[L" + className + ";") || name.equals("valueOf") && desc.equals("(Ljava/lang/String;)L" + className + ";") || name.equals("<init>") && signature != null && signature.equals("()V");
    }

    protected abstract MethodVisitor createMethodLineEnumerator(MethodVisitor var1, String var2, String var3, int var4, String var5, String[] var6);

    public void visitEnd() {
        if (this.myProcess) {
            this.initLineData();
            this.myLines = null;
        }
        super.visitEnd();
    }

    protected abstract void initLineData();

    protected void getOrCreateLineData(int line, String name, String desc) {
        LineData lineData;
        if (this.myLines == null) {
            this.myLines = new TIntObjectHashMap();
        }
        if ((lineData = (LineData)this.myLines.get(line)) == null) {
            lineData = new LineData(line, StringsPool.getFromPool(name + desc));
            this.myLines.put(line, (Object)lineData);
        }
        if (line > this.myMaxLineNumber) {
            this.myMaxLineNumber = line;
        }
    }

    public void removeLine(int line) {
        this.myLines.remove(line);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(this.myClassName).setSource(source);
        }
        if (debug != null) {
            this.myProjectData.addLineMaps(this.myClassName, JSR45Util.extractLineMapping(debug, this.myClassName));
        }
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(outerClassName).setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }
}

