/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidAarDepsBuildTarget
extends AndroidBuildTarget {
    public AndroidAarDepsBuildTarget(JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        Set libraries = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singleton(this.myModule)).runtimeOnly().productionOnly().getLibraries();
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (JpsLibrary library : libraries) {
            Pair<File, List<File>> pair = AndroidJpsUtil.getResDirAndJarsIfAar(library);
            List jars = pair != null ? (List)pair.getSecond() : null;
            if (jars == null) continue;
            for (File jar : jars) {
                result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, jar));
            }
        }
        return result;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singleton(this.getOutputFile(context));
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        return this.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths());
    }

    @NotNull
    public File getOutputFile(BuildDataPaths dataPaths) {
        JpsModule module = this.myModule;
        return AndroidAarDepsBuildTarget.getOutputFile(module, dataPaths);
    }

    @NotNull
    public static File getOutputFile(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir, "aar_deps.jar");
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidAarDepsBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        MyTargetType() {
            super("android-aar-deps", "AAR Dependencies Packaging");
        }

        @Override
        @Nullable
        public AndroidAarDepsBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            return !extension.isLibrary() ? new AndroidAarDepsBuildTarget(extension.getModule()) : null;
        }
    }
}

