/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidDxRunner;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.AndroidProGuardOptionsStorageProvider;
import org.jetbrains.jps.android.AndroidProGuardStateStorage;
import org.jetbrains.jps.android.ProGuardOptions;
import org.jetbrains.jps.android.builder.AndroidDexBuildTarget;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidDexCompilerConfiguration;
import org.jetbrains.jps.android.model.JpsAndroidExtensionService;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidDexBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidDexBuildTarget> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidDexBuilder");
    @NonNls
    private static final String DEX_BUILDER_NAME = "Android Dex";
    @NonNls
    private static final String PRO_GUARD_BUILDER_NAME = "ProGuard";

    public AndroidDexBuilder() {
        super(Collections.singletonList(AndroidDexBuildTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidDexBuildTarget buildTarget, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidDexBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        assert (!AndroidJpsUtil.isLightBuild(context));
        try {
            if (!AndroidDexBuilder.doDexBuild(buildTarget, context, holder.hasDirtyFiles() || holder.hasRemovedFiles(), outputConsumer)) {
                throw new StopBuildException();
            }
        }
        catch (ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            AndroidJpsUtil.handleException(context, e, DEX_BUILDER_NAME, LOG);
        }
    }

    private static boolean isPredexingInScope(@NotNull CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        return context.getScope().isAffected((BuildTarget)new AndroidPreDexBuildTarget(project));
    }

    private static boolean doDexBuild(@NotNull AndroidDexBuildTarget target, @NotNull CompileContext context, boolean hasDirtyFiles, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        assert (extension != null);
        assert (!extension.isLibrary());
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, DEX_BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        File dexOutputDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
        if ((dexOutputDir = AndroidJpsUtil.createDirIfNotExist(dexOutputDir, context, DEX_BUILDER_NAME)) == null) {
            return false;
        }
        ProGuardOptions proGuardOptions = AndroidJpsUtil.getProGuardConfigIfShouldRun(context, extension);
        if (proGuardOptions != null && proGuardOptions.getCfgFiles() == null) {
            context.processMessage((BuildMessage)new CompilerMessage(DEX_BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.cannot.find.proguard.cfg", module.getName())));
            return false;
        }
        File proguardCfgOutputFile = new File(dexOutputDir, "proguard.txt");
        AndroidProGuardStateStorage proGuardOptionsStorage = (AndroidProGuardStateStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)target, (StorageProvider)AndroidProGuardOptionsStorageProvider.INSTANCE);
        AndroidProGuardStateStorage.MyState oldProGuardState = proGuardOptionsStorage.read();
        AndroidProGuardStateStorage.MyState newProGuardState = null;
        try {
            boolean success;
            Object fileSet;
            if (proGuardOptions != null) {
                ArrayList<String> proguardCfgFilePathsList = new ArrayList<String>();
                for (File file : proGuardOptions.getCfgFiles()) {
                    proguardCfgFilePathsList.add(file.getAbsolutePath());
                }
                proguardCfgFilePathsList.add(proguardCfgOutputFile.getPath());
                String[] proguardCfgFilePaths = ArrayUtil.toStringArray(proguardCfgFilePathsList);
                String outputJarPath = FileUtil.toSystemDependentName((String)(dexOutputDir.getPath() + '/' + "obfuscated_sources.jar"));
                Pair<Boolean, AndroidProGuardStateStorage.MyState> pair = AndroidDexBuilder.runProguardIfNecessary(extension, target, platform, context, outputJarPath, proguardCfgFilePaths, hasDirtyFiles, oldProGuardState);
                if (pair == null) {
                    return false;
                }
                if (!((Boolean)pair.getFirst()).booleanValue()) {
                    return true;
                }
                newProGuardState = (AndroidProGuardStateStorage.MyState)pair.getSecond();
                assert (newProGuardState != null);
                fileSet = Collections.singleton(outputJarPath);
            } else {
                if (!hasDirtyFiles && oldProGuardState == null) {
                    return true;
                }
                List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
                fileSet = new HashSet();
                boolean predexingEnabled = extension.isPreDexingEnabled() && AndroidDexBuilder.isPredexingInScope(context);
                for (BuildRootDescriptor root : roots) {
                    File rootFile = root.getRootFile();
                    if (!rootFile.exists()) continue;
                    if (root instanceof AndroidDexBuildTarget.MyClassesDirBuildRootDescriptor) {
                        AndroidDexBuildTarget.ClassesDirType type = ((AndroidDexBuildTarget.MyClassesDirBuildRootDescriptor)root).getClassesDirType();
                        if (type == AndroidDexBuildTarget.ClassesDirType.JAVA) {
                            fileSet.add(rootFile.getPath());
                            continue;
                        }
                        if (type != AndroidDexBuildTarget.ClassesDirType.ANDROID_APP) continue;
                        AndroidJpsUtil.addSubdirectories(rootFile, (Collection<String>)fileSet);
                        continue;
                    }
                    if (!(root instanceof AndroidDexBuildTarget.MyJarBuildRootDescriptor) || ((AndroidDexBuildTarget.MyJarBuildRootDescriptor)root).isPreDexed() != predexingEnabled) continue;
                    fileSet.add(rootFile.getPath());
                }
            }
            if (fileSet.size() > 0) {
                Object[] files = new String[fileSet.size()];
                int i = 0;
                for (String filePath : fileSet) {
                    files[i++] = FileUtil.toSystemDependentName((String)filePath);
                }
                context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.dex", module.getName())));
                Arrays.sort(files);
                success = AndroidDexBuilder.runDex(platform, dexOutputDir.getPath(), (String[])files, context, module, outputConsumer);
            } else {
                success = true;
            }
            if (success) {
                proGuardOptionsStorage.update(newProGuardState);
            }
            return success;
        }
        catch (IOException e) {
            AndroidJpsUtil.reportExceptionError(context, null, e, DEX_BUILDER_NAME);
            return false;
        }
    }

    @NotNull
    public String getPresentableName() {
        return DEX_BUILDER_NAME;
    }

    private static boolean runDex(@NotNull AndroidPlatform platform, @NotNull String outputDir, @NotNull String[] compileTargets, @NotNull CompileContext context, @NotNull JpsModule module, @NotNull BuildOutputConsumer outputConsumer) throws IOException {
        String outFilePath = outputDir + File.separatorChar + "classes.dex";
        return AndroidDexBuilder.runDex(platform, outFilePath, compileTargets, context, module.getProject(), outputConsumer, DEX_BUILDER_NAME, module.getName(), module);
    }

    public static boolean runDex(@NotNull AndroidPlatform platform, @NotNull String outFilePath, @NotNull String[] compileTargets, @NotNull CompileContext context, @NotNull JpsProject project, @NotNull BuildOutputConsumer outputConsumer, @NotNull String builderName, @NotNull String srcTargetName, @Nullable JpsModule module) throws IOException {
        boolean success;
        String javaExecutable;
        JpsAndroidModuleExtension extension;
        List<String> vmOptions;
        JpsAndroidModuleExtension extension2;
        BuildToolInfo buildToolInfo = platform.getTarget().getBuildToolInfo();
        if (buildToolInfo == null) {
            return false;
        }
        String dxJarPath = FileUtil.toSystemDependentName((String)buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR));
        AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
        File dxJar = new File(dxJarPath);
        if (testingManager == null && !dxJar.isFile()) {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.find.file", dxJarPath)));
            return false;
        }
        boolean multiDex = false;
        if (module != null && (extension2 = AndroidJpsUtil.getExtension(module)) != null && extension2.isMultiDexEnabled()) {
            outFilePath = new File(outFilePath).getParent();
            multiDex = true;
        }
        ArrayList<String> programParamList = new ArrayList<String>();
        programParamList.add(dxJarPath);
        programParamList.add(outFilePath);
        JpsAndroidDexCompilerConfiguration configuration = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(project);
        if (configuration != null) {
            vmOptions = new ArrayList<String>();
            vmOptions.addAll(ParametersListUtil.parse((String)configuration.getVmOptions()));
            if (!AndroidCommonUtils.hasXmxParam(vmOptions)) {
                vmOptions.add("-Xmx" + configuration.getMaxHeapSize() + "M");
            }
            programParamList.addAll(Arrays.asList("--optimize", Boolean.toString(configuration.isOptimize())));
            if (configuration.isForceJumbo()) {
                programParamList.addAll(Arrays.asList("--forceJumbo", Boolean.TRUE.toString()));
            }
            if (configuration.isCoreLibrary()) {
                programParamList.add("--coreLibrary");
            }
        } else {
            vmOptions = Collections.singletonList("-Xmx1024M");
        }
        if (multiDex && (extension = AndroidJpsUtil.getExtension(module)) != null) {
            programParamList.add("--multi-dex");
            if (!StringUtil.isEmpty((String)extension.getMainDexList())) {
                programParamList.add("--main-dex-list");
                programParamList.add(extension.getMainDexList());
            }
            if (extension.isMinimalMainDex()) {
                programParamList.add("--minimal-main-dex");
            }
        }
        programParamList.addAll(Arrays.asList(compileTargets));
        programParamList.add("--exclude");
        ArrayList<String> classPath = new ArrayList<String>();
        classPath.add(ClasspathBootstrap.getResourcePath(AndroidDxRunner.class));
        classPath.add(ClasspathBootstrap.getResourcePath(FileUtilRt.class));
        File outFile = new File(outFilePath);
        if (outFile.exists() && !outFile.isDirectory() && !outFile.delete()) {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.WARNING, AndroidJpsBundle.message("android.jps.cannot.delete.file", outFilePath)));
        }
        if ((javaExecutable = AndroidDexBuilder.getJavaExecutable(platform, context, builderName)) == null) {
            return false;
        }
        List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)javaExecutable, (String)AndroidDxRunner.class.getName(), Collections.emptyList(), classPath, vmOptions, programParamList);
        LOG.info(AndroidCommonUtils.command2string((Collection)commandLine));
        String[] commands = ArrayUtil.toStringArray((Collection)commandLine);
        Process process = testingManager != null ? testingManager.getCommandExecutor().createProcess(commands, Collections.emptyMap()) : Runtime.getRuntime().exec(commands);
        HashMap messages = new HashMap(3);
        messages.put((Object)AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put((Object)AndroidCompilerMessageKind.WARNING, new ArrayList());
        messages.put((Object)AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        AndroidCommonUtils.handleDexCompilationResult((Process)process, (String)StringUtil.join((Collection)commandLine, (String)" "), (String)outFilePath, (Map)messages, (boolean)multiDex);
        AndroidJpsUtil.addMessages(context, (Map<AndroidCompilerMessageKind, List<String>>)messages, builderName, srcTargetName);
        boolean bl = success = ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).size() == 0;
        if (success) {
            final ArrayList<String> srcFiles = new ArrayList<String>();
            for (String compileTargetPath : compileTargets) {
                File compileTarget = new File(compileTargetPath);
                if (compileTarget.isFile()) {
                    srcFiles.add(compileTargetPath);
                    continue;
                }
                if (!compileTarget.isDirectory()) continue;
                AndroidJpsUtil.processClassFilesAndJarsRecursively(compileTarget, new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isFile()) {
                            srcFiles.add(file.getPath());
                        }
                        return true;
                    }
                });
            }
            outputConsumer.registerOutputFile(outFile, srcFiles);
        }
        return success;
    }

    @Nullable
    private static String getJavaExecutable(@NotNull AndroidPlatform platform, @NotNull CompileContext context, @NotNull String builderName) {
        JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk = platform.getSdk();
        String jdkName = ((JpsAndroidSdkProperties)((JpsSimpleElement)sdk.getSdkProperties()).getData()).getJdkName();
        JpsLibrary javaSdk = context.getProjectDescriptor().getModel().getGlobal().getLibraryCollection().findLibrary(jdkName);
        if (javaSdk == null || !javaSdk.getType().equals(JpsJavaSdkType.INSTANCE)) {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.java.sdk.not.specified", jdkName)));
            return null;
        }
        return JpsJavaSdkType.getJavaExecutable((JpsSdk)((JpsSdk)javaSdk.getProperties()));
    }

    private static Pair<Boolean, AndroidProGuardStateStorage.MyState> runProguardIfNecessary(@NotNull JpsAndroidModuleExtension extension, @NotNull AndroidDexBuildTarget target, @NotNull AndroidPlatform platform, @NotNull CompileContext context, @NotNull String outputJarPath, @NotNull String[] proguardCfgPaths, boolean hasDirtyFiles, @Nullable AndroidProGuardStateStorage.MyState oldState) throws IOException {
        String proguardVmOptions;
        JpsModule module = extension.getModule();
        File[] proguardCfgFiles = new File[proguardCfgPaths.length];
        for (int i = 0; i < proguardCfgFiles.length; ++i) {
            proguardCfgFiles[i] = new File(proguardCfgPaths[i]);
            if (proguardCfgFiles[i].exists()) continue;
            context.processMessage((BuildMessage)new CompilerMessage(PRO_GUARD_BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.find.file", proguardCfgPaths[i])));
            return null;
        }
        File mainContentRoot = AndroidJpsUtil.getMainContentRoot(extension);
        if (mainContentRoot == null) {
            context.processMessage((BuildMessage)new CompilerMessage(PRO_GUARD_BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.main.content.root.not.found", module.getName())));
            return null;
        }
        String javaExecutable = AndroidDexBuilder.getJavaExecutable(platform, context, PRO_GUARD_BUILDER_NAME);
        if (javaExecutable == null) {
            return null;
        }
        File proguardLogsDir = extension.getProguardLogsDir();
        File logsDir = proguardLogsDir != null ? proguardLogsDir : new File(mainContentRoot.getPath() + '/' + "proguard_logs");
        AndroidProGuardStateStorage.MyState newState = new AndroidProGuardStateStorage.MyState(proguardCfgFiles);
        if (!hasDirtyFiles && newState.equals(oldState)) {
            return Pair.create((Object)false, null);
        }
        ArrayList<String> classesDirs = new ArrayList<String>();
        ArrayList<String> libClassesDirs = new ArrayList<String>();
        ArrayList<String> externalJars = new ArrayList<String>();
        ArrayList<String> providedJars = new ArrayList<String>();
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        for (BuildRootDescriptor root : roots) {
            File rootFile = root.getRootFile();
            if (!rootFile.exists()) continue;
            if (root instanceof AndroidDexBuildTarget.MyClassesDirBuildRootDescriptor) {
                AndroidDexBuildTarget.ClassesDirType type = ((AndroidDexBuildTarget.MyClassesDirBuildRootDescriptor)root).getClassesDirType();
                if (type == AndroidDexBuildTarget.ClassesDirType.JAVA || type == AndroidDexBuildTarget.ClassesDirType.ANDROID_APP) {
                    AndroidJpsUtil.addSubdirectories(rootFile, classesDirs);
                    continue;
                }
                AndroidJpsUtil.addSubdirectories(rootFile, libClassesDirs);
                continue;
            }
            if (root instanceof AndroidDexBuildTarget.MyJarBuildRootDescriptor) {
                AndroidDexBuildTarget.MyJarBuildRootDescriptor jarRoot = (AndroidDexBuildTarget.MyJarBuildRootDescriptor)root;
                if (jarRoot.isLibPackage() || jarRoot.isPreDexed()) continue;
                externalJars.add(rootFile.getPath());
                continue;
            }
            if (!(root instanceof AndroidDexBuildTarget.MyProvidedJarBuildRootDescriptor)) continue;
            providedJars.add(rootFile.getPath());
        }
        String[] classFilesDirOsPaths = ArrayUtil.toStringArray(classesDirs);
        String[] libClassFilesDirOsPaths = ArrayUtil.toStringArray(libClassesDirs);
        String[] externalJarOsPaths = ArrayUtil.toStringArray(externalJars);
        String[] providedJarOsPaths = ArrayUtil.toStringArray(providedJars);
        String inputJarOsPath = AndroidCommonUtils.buildTempInputJar((String[])classFilesDirOsPaths, (String[])libClassFilesDirOsPaths);
        AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
        if (testingManager != null) {
            testingManager.getCommandExecutor().checkJarContent("proguard_input_jar", inputJarOsPath);
        }
        if (!logsDir.exists() && !logsDir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(PRO_GUARD_BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", FileUtil.toSystemDependentName((String)logsDir.getPath()))));
            return null;
        }
        JpsAndroidDexCompilerConfiguration configuration = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(module.getProject());
        String string = proguardVmOptions = configuration != null ? configuration.getProguardVmOptions() : null;
        if (proguardVmOptions == null) {
            proguardVmOptions = "";
        }
        context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.proguard", module.getName())));
        Map messages = AndroidCommonUtils.launchProguard((IAndroidTarget)platform.getTarget(), (int)platform.getSdkToolsRevision(), (String)platform.getSdk().getHomePath(), (String)javaExecutable, (String)proguardVmOptions, (String[])proguardCfgPaths, (String)inputJarOsPath, (String[])externalJarOsPaths, (String[])providedJarOsPaths, (String)outputJarPath, (String)logsDir.getPath());
        AndroidJpsUtil.addMessages(context, messages, PRO_GUARD_BUILDER_NAME, module.getName());
        return ((List)messages.get(AndroidCompilerMessageKind.ERROR)).isEmpty() ? Pair.create((Object)true, (Object)newState) : null;
    }
}

